/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLConst;

public interface GLPipeline
extends GLConst {
    public static final String TAG = GLPipeline.class.getSimpleName();

    public void release();

    public void resize(int var1, int var2) throws IllegalStateException;

    public boolean isValid();

    public boolean isActive();

    public int getWidth();

    public int getHeight();

    public void setParent(@Nullable GLPipeline var1);

    @Nullable
    public GLPipeline getParent();

    public void setPipeline(@Nullable GLPipeline var1);

    @Nullable
    public GLPipeline getPipeline();

    public void remove();

    @WorkerThread
    public void onFrameAvailable(boolean var1, int var2, @NonNull @Size(min=16L) float[] var3);

    public void refresh();

    @NonNull
    public static GLPipeline findLast(@NonNull GLPipeline pipeline) {
        GLPipeline parent = pipeline;
        GLPipeline next = parent.getPipeline();
        while (next != null) {
            parent = next;
            next = parent.getPipeline();
        }
        return parent;
    }

    @NonNull
    public static GLPipeline findFirst(@NonNull GLPipeline pipeline) {
        GLPipeline current = pipeline;
        GLPipeline parent = current.getParent();
        while (parent != null) {
            current = parent;
            parent = current.getParent();
        }
        return current;
    }

    @Nullable
    public static <T extends GLPipeline> T find(@NonNull GLPipeline pipeline, @NonNull Class<T> clazz) {
        for (GLPipeline p = GLPipeline.findFirst(pipeline); p != null; p = p.getPipeline()) {
            if (p.getClass() != clazz) continue;
            return (T)((GLPipeline)clazz.cast(p));
        }
        return null;
    }

    @NonNull
    public static GLPipeline append(@NonNull GLPipeline chain, @NonNull GLPipeline pipeline) {
        GLPipeline last = GLPipeline.findLast(chain);
        last.setPipeline(pipeline);
        return pipeline;
    }

    @NonNull
    public static GLPipeline insert(@NonNull GLPipeline target, @NonNull GLPipeline pipeline) {
        GLPipeline p = target.getPipeline();
        if (p == null) {
            target.setPipeline(pipeline);
        } else if (p != pipeline) {
            GLPipeline last = GLPipeline.findLast(pipeline);
            target.setPipeline(pipeline);
            last.setPipeline(p);
        }
        return pipeline;
    }

    @NonNull
    public static String pipelineString(@NonNull GLPipeline root) {
        StringBuilder sb = new StringBuilder("[");
        for (GLPipeline pipeline = root; pipeline != null; pipeline = pipeline.getPipeline()) {
            if (pipeline != root) {
                sb.append(',');
            }
            sb.append(pipeline);
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean validatePipelineChain(@NonNull GLPipeline root) {
        boolean result = true;
        GLPipeline pipeline = root;
        while (pipeline != null) {
            GLPipeline next = pipeline.getPipeline();
            if (next != null && next.getParent() != pipeline) {
                Log.v((String)TAG, (String)("validatePipelineChain:found wrong chain" + pipeline + "=>" + next + (next != null ? "(" + next.getParent() + ")" : "")));
                next.setParent(pipeline);
                result = false;
            }
            pipeline = next;
        }
        return result;
    }
}

