/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.FaceDetector;
import android.opengl.GLES20;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glpipeline.ProxyPipeline;
import com.serenegiant.math.Fraction;
import com.serenegiant.utils.HandlerThreadHandler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FaceDetectPipeline
extends ProxyPipeline {
    private static final boolean DEBUG = false;
    private static final String TAG = FaceDetectPipeline.class.getSimpleName();
    private static final float DEFAULT_MAX_FPS = 1.0f;
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    private final float mMaxFps;
    private final int mMaxDetectNum;
    @NonNull
    private final OnDetectedListener mListener;
    private final FaceDetector.Face[] mDetected;
    @NonNull
    private final HandlerThreadHandler mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
    @Nullable
    private GLDrawer2D mDrawer;
    @Nullable
    private RendererTarget mRendererTarget;
    @Nullable
    private EGLBase.IEglSurface offscreen;
    @Nullable
    private ByteBuffer mWorkBuffer;
    @Nullable
    private Bitmap mWorkBitmap;
    @Nullable
    private FaceDetector mDetector;
    private int cnt;
    private final Runnable mDetectTask = new Runnable(){
        private final Matrix m = new Matrix();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void run() {
            int height;
            int width;
            Bitmap bitmap565;
            Object object = FaceDetectPipeline.this.mSync;
            synchronized (object) {
                if (FaceDetectPipeline.this.mWorkBitmap == null) {
                    return;
                }
                bitmap565 = FaceDetectPipeline.this.mWorkBitmap.copy(Bitmap.Config.RGB_565, true);
                width = FaceDetectPipeline.this.getWidth();
                height = FaceDetectPipeline.this.getHeight();
            }
            this.m.preScale(1.0f, -1.0f);
            Bitmap flippedBitmap = Bitmap.createBitmap((Bitmap)bitmap565, (int)0, (int)0, (int)width, (int)height, (Matrix)this.m, (boolean)true);
            bitmap565.recycle();
            int n = FaceDetectPipeline.this.mDetector.findFaces(flippedBitmap, FaceDetectPipeline.this.mDetected);
            if (n > 0) {
                FaceDetectPipeline.this.mListener.onDetected(n, FaceDetectPipeline.this.mDetected, width, height);
            }
            flippedBitmap.recycle();
        }
    };

    public FaceDetectPipeline(@NonNull GLManager manager, @Nullable Fraction maxFps, @IntRange(from=1L) int maxDetectNum, @NonNull OnDetectedListener listener) {
        this.mManager = manager;
        this.mMaxFps = maxFps != null ? maxFps.asFloat() : 1.0f;
        this.mMaxDetectNum = maxDetectNum;
        this.mListener = listener;
        this.mDetected = new FaceDetector.Face[maxDetectNum];
    }

    @Override
    protected void internalRelease() {
        if (this.isValid()) {
            this.releaseTarget();
            this.mAsyncHandler.removeCallbacksAndMessages(null);
            this.mAsyncHandler.quit();
        }
        super.internalRelease();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.mManager.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        super.onFrameAvailable(isOES, texId, texMatrix);
        if (this.isActive()) {
            RendererTarget target;
            GLDrawer2D drawer;
            int height;
            int width;
            Object object = this.mSync;
            synchronized (object) {
                width = this.getWidth();
                height = this.getHeight();
                if (this.mDrawer == null || isOES != this.mDrawer.isOES()) {
                    if (this.mDrawer != null) {
                        this.mDrawer.release();
                    }
                    this.mDrawer = GLDrawer2D.create(this.mManager.isGLES3(), isOES);
                }
                drawer = this.mDrawer;
                if (this.mRendererTarget == null || this.mRendererTarget.width() != width || this.mRendererTarget.height() != height) {
                    this.createTarget();
                }
                target = this.mRendererTarget;
            }
            if (target != null && target.canDraw()) {
                target.draw(drawer, 33984, texId, texMatrix);
                this.offscreen.makeCurrent();
                this.mWorkBuffer.clear();
                GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)this.mWorkBuffer);
                this.mWorkBuffer.clear();
                this.mAsyncHandler.removeCallbacks(this.mDetectTask);
                object = this.mSync;
                synchronized (object) {
                    if (this.mWorkBitmap != null) {
                        this.mWorkBitmap.copyPixelsFromBuffer((Buffer)this.mWorkBuffer);
                        this.mAsyncHandler.post(this.mDetectTask);
                    }
                }
            }
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isValid()) {
            this.mManager.runOnGLThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @WorkerThread
                public void run() {
                    GLDrawer2D drawer;
                    Object object = FaceDetectPipeline.this.mSync;
                    synchronized (object) {
                        drawer = FaceDetectPipeline.this.mDrawer;
                        FaceDetectPipeline.this.mDrawer = null;
                    }
                    if (drawer != null) {
                        drawer.release();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void createTarget() {
        int width = this.getWidth();
        int height = this.getHeight();
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRendererTarget != null) {
                this.mRendererTarget.release();
                this.mRendererTarget = null;
            }
            if (this.offscreen != null) {
                this.offscreen.release();
                this.offscreen = null;
            }
            if (this.mWorkBitmap != null) {
                this.mWorkBitmap.recycle();
                this.mWorkBitmap = null;
            }
            this.offscreen = this.mManager.getEgl().createOffscreen(width, height);
            this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), this.offscreen, this.mMaxFps > 0.0f ? this.mMaxFps : 1.0f);
            this.mWorkBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.LITTLE_ENDIAN);
            this.mWorkBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mDetector = new FaceDetector(width, height, this.mMaxDetectNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void releaseTarget() {
        EGLBase.IEglSurface surface;
        RendererTarget target;
        GLDrawer2D drawer;
        Object object = this.mSync;
        synchronized (object) {
            drawer = this.mDrawer;
            this.mDrawer = null;
            target = this.mRendererTarget;
            this.mRendererTarget = null;
            surface = this.offscreen;
            this.offscreen = null;
            if (this.mWorkBitmap != null) {
                this.mWorkBitmap.recycle();
                this.mWorkBitmap = null;
            }
            this.mWorkBuffer = null;
            this.mDetector = null;
        }
        if ((drawer != null || target != null) && this.mManager.isValid()) {
            try {
                this.mManager.runOnGLThread(new Runnable(){

                    @Override
                    @WorkerThread
                    public void run() {
                        if (drawer != null) {
                            drawer.release();
                        }
                        if (target != null) {
                            target.release();
                        }
                        if (surface != null) {
                            surface.release();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface OnDetectedListener {
        @WorkerThread
        public void onDetected(int var1, FaceDetector.Face[] var2, int var3, int var4);
    }
}

