/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.gl;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import com.serenegiant.gl.GLConst;
import com.serenegiant.gl.GLUtils;

public class GLTexture
implements GLConst {
    private static final boolean DEBUG = false;
    private static final String TAG = GLTexture.class.getSimpleName();
    private static final boolean DEFAULT_ADJUST_POWER2 = false;
    private final int TEX_TARGET;
    private final int TEX_UNIT;
    private final int FILTER_PARAM;
    private final boolean ADJUST_POWER2;
    private final boolean mWrappedTexture;
    private int mTextureId;
    @Size(min=16L)
    @NonNull
    private final float[] mTexMatrix = new float[16];
    private int mTexWidth;
    private int mTexHeight;
    private int mWidth;
    private int mHeight;
    private int viewPortX;
    private int viewPortY;
    private int viewPortWidth;
    private int viewPortHeight;
    @Size(min=16L)
    @NonNull
    private final float[] mResultMatrix = new float[16];

    public static GLTexture newInstance(int width, int height) {
        return new GLTexture(3553, 33984, -1, width, height, false, 9729);
    }

    public static GLTexture newInstance(int texUnit, int width, int height) {
        return new GLTexture(3553, texUnit, -1, width, height, false, 9729);
    }

    public static GLTexture newInstance(int texUnit, int width, int height, int filter_param) {
        return new GLTexture(3553, texUnit, -1, width, height, false, filter_param);
    }

    public static GLTexture newInstance(int texUnit, int width, int height, boolean adjust_power2, int filter_param) {
        return new GLTexture(3553, texUnit, -1, width, height, adjust_power2, filter_param);
    }

    public static GLTexture wrap(int texTarget, int texUnit, int texId, int width, int height) {
        return new GLTexture(texTarget, texUnit, texId, width, height, false, 9729);
    }

    protected GLTexture(int texTarget, int texUnit, int texId, int width, int height, boolean adjust_power2, int filter_param) {
        this.TEX_TARGET = texTarget;
        this.TEX_UNIT = texUnit;
        this.mWrappedTexture = texId > -1;
        this.mTextureId = texId;
        this.FILTER_PARAM = filter_param;
        this.ADJUST_POWER2 = adjust_power2 && texId <= -1;
        this.createTexture(width, height);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        this.releaseTexture();
    }

    public void bind() {
        GLES20.glActiveTexture((int)this.TEX_UNIT);
        GLES20.glBindTexture((int)this.TEX_TARGET, (int)this.mTextureId);
        this.setViewPort(this.viewPortX, this.viewPortY, this.viewPortWidth, this.viewPortHeight);
    }

    public void bindTexture() {
        GLES20.glActiveTexture((int)this.TEX_UNIT);
        GLES20.glBindTexture((int)this.TEX_TARGET, (int)this.mTextureId);
    }

    public void setViewPort(int x, int y, int width, int height) {
        this.viewPortX = x;
        this.viewPortY = y;
        this.viewPortWidth = width;
        this.viewPortHeight = height;
        GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public void unbind() {
        GLES20.glActiveTexture((int)this.TEX_UNIT);
        GLES20.glBindTexture((int)this.TEX_TARGET, (int)0);
    }

    public boolean isValid() {
        return this.mTextureId > -1;
    }

    public boolean isOES() {
        return this.TEX_TARGET == 36197;
    }

    public int getTexTarget() {
        return this.TEX_TARGET;
    }

    public int getTexUnit() {
        return this.TEX_UNIT;
    }

    public int getTexId() {
        return this.mTextureId;
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    @Size(min=16L)
    @NonNull
    public float[] copyTexMatrix() {
        System.arraycopy(this.mTexMatrix, 0, this.mResultMatrix, 0, 16);
        return this.mResultMatrix;
    }

    public void copyTexMatrix(@NonNull @Size(min=16L) float[] matrix, int offset) {
        System.arraycopy(this.mTexMatrix, 0, matrix, offset, this.mTexMatrix.length);
    }

    @Size(min=16L)
    @NonNull
    public float[] getTexMatrix() {
        return this.mTexMatrix;
    }

    public int getTexWidth() {
        return this.mTexWidth;
    }

    public int getTexHeight() {
        return this.mTexHeight;
    }

    public void loadBitmap(@NonNull Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (!this.mWrappedTexture && width > this.mTexWidth || height > this.mTexHeight) {
            this.releaseTexture();
            this.createTexture(width, height);
        }
        this.bindTexture();
        android.opengl.GLUtils.texImage2D((int)this.TEX_TARGET, (int)0, (Bitmap)bitmap, (int)0);
        GLES20.glBindTexture((int)this.TEX_TARGET, (int)0);
        Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
        this.mTexMatrix[0] = (float)width / (float)this.mTexWidth;
        this.mTexMatrix[5] = (float)height / (float)this.mTexHeight;
    }

    private void createTexture(int width, int height) {
        if (this.mTextureId <= -1) {
            if (this.ADJUST_POWER2) {
                int h;
                int w;
                for (w = 1; w < width; w <<= 1) {
                }
                for (h = 1; h < height; h <<= 1) {
                }
                if (this.mTexWidth != w || this.mTexHeight != h) {
                    this.mTexWidth = w;
                    this.mTexHeight = h;
                }
            } else {
                this.mTexWidth = width;
                this.mTexHeight = height;
            }
            this.mWidth = width;
            this.mHeight = height;
            this.mTextureId = GLUtils.initTex(this.TEX_TARGET, this.TEX_UNIT, this.FILTER_PARAM);
            GLES20.glTexImage2D((int)this.TEX_TARGET, (int)0, (int)6408, (int)this.mTexWidth, (int)this.mTexHeight, (int)0, (int)6408, (int)5121, null);
        } else {
            this.mWidth = this.mTexWidth = width;
            this.mHeight = this.mTexHeight = height;
        }
        Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
        this.mTexMatrix[0] = (float)this.mWidth / (float)this.mTexWidth;
        this.mTexMatrix[5] = (float)this.mHeight / (float)this.mTexHeight;
        this.setViewPort(0, 0, this.mWidth, this.mHeight);
    }

    private void releaseTexture() {
        if (!this.mWrappedTexture && this.mTextureId > -1) {
            GLUtils.deleteTex(this.mTextureId);
            this.mTextureId = -1;
        }
    }
}

