/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.gl;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.Size;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.IGLSurface;

public abstract class GLSurface
implements IGLSurface {
    private static final boolean DEBUG = false;
    private static final String TAG = "GLSurface";
    private static final boolean DEFAULT_ADJUST_POWER2 = false;
    protected final boolean isGLES3;
    protected final int TEX_TARGET;
    protected final int TEX_UNIT;
    protected final boolean mHasDepthBuffer;
    protected final boolean mAdjustPower2;
    protected boolean mWrappedTexture;
    protected int mWidth;
    protected int mHeight;
    protected int mTexWidth;
    protected int mTexHeight;
    protected int mFBOTexId = -1;
    protected int mDepthBufferObj = -1;
    protected int mFrameBufferObj = -1;
    @Size(min=16L)
    @NonNull
    protected final float[] mTexMatrix = new float[16];
    protected int viewPortX;
    protected int viewPortY;
    protected int viewPortWidth;
    protected int viewPortHeight;
    @Size(min=16L)
    @NonNull
    private final float[] mResultMatrix = new float[16];

    @SuppressLint(value={"NewApi"})
    public static GLSurface newInstance(boolean isGLES3, int width, int height) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLSurfaceES3(3553, 33984, -1, width, height, false, false);
        }
        return new GLSurfaceES2(3553, 33984, -1, width, height, false, false);
    }

    @SuppressLint(value={"NewApi"})
    public static GLSurface newInstance(boolean isGLES3, int tex_unit, int width, int height) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLSurfaceES3(3553, tex_unit, -1, width, height, false, false);
        }
        return new GLSurfaceES2(3553, tex_unit, -1, width, height, false, false);
    }

    @SuppressLint(value={"NewApi"})
    public static GLSurface newInstance(boolean isGLES3, int width, int height, boolean use_depth_buffer) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLSurfaceES3(3553, 33984, -1, width, height, use_depth_buffer, false);
        }
        return new GLSurfaceES2(3553, 33984, -1, width, height, use_depth_buffer, false);
    }

    @SuppressLint(value={"NewApi"})
    public static GLSurface newInstance(boolean isGLES3, int tex_unit, int width, int height, boolean use_depth_buffer) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLSurfaceES3(3553, tex_unit, -1, width, height, use_depth_buffer, false);
        }
        return new GLSurfaceES2(3553, tex_unit, -1, width, height, use_depth_buffer, false);
    }

    @SuppressLint(value={"NewApi"})
    public static GLSurface newInstance(boolean isGLES3, int width, int height, boolean use_depth_buffer, boolean adjust_power2) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLSurfaceES3(3553, 33984, -1, width, height, use_depth_buffer, adjust_power2);
        }
        return new GLSurfaceES2(3553, 33984, -1, width, height, use_depth_buffer, adjust_power2);
    }

    @SuppressLint(value={"NewApi"})
    public static GLSurface newInstance(boolean isGLES3, int tex_unit, int width, int height, boolean use_depth_buffer, boolean adjust_power2) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLSurfaceES3(3553, tex_unit, -1, width, height, use_depth_buffer, adjust_power2);
        }
        return new GLSurfaceES2(3553, tex_unit, -1, width, height, use_depth_buffer, adjust_power2);
    }

    @SuppressLint(value={"NewApi"})
    public static GLSurface wrap(boolean isGLES3, int tex_unit, int tex_id, int width, int height) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLSurfaceES3(3553, tex_unit, tex_id, width, height, false, false);
        }
        return new GLSurfaceES2(3553, tex_unit, tex_id, width, height, false, false);
    }

    @SuppressLint(value={"NewApi"})
    public static GLSurface wrap(boolean isGLES3, int tex_unit, int tex_id, int width, int height, boolean use_depth_buffer) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLSurfaceES3(3553, tex_unit, tex_id, width, height, use_depth_buffer, false);
        }
        return new GLSurfaceES2(3553, tex_unit, tex_id, width, height, use_depth_buffer, false);
    }

    @SuppressLint(value={"NewApi"})
    public static GLSurface wrap(boolean isGLES3, int tex_target, int tex_unit, int tex_id, int width, int height, boolean use_depth_buffer) {
        if (isGLES3 && GLUtils.getSupportedGLVersion() > 2) {
            return new GLSurfaceES3(tex_target, tex_unit, tex_id, width, height, use_depth_buffer, false);
        }
        return new GLSurfaceES2(tex_target, tex_unit, tex_id, width, height, use_depth_buffer, false);
    }

    @SuppressLint(value={"NewApi"})
    private GLSurface(boolean isGLES3, int tex_target, int tex_unit, int tex_id, int width, int height, boolean use_depth_buffer, boolean adjust_power2) {
        this.isGLES3 = isGLES3;
        this.TEX_TARGET = tex_target;
        this.TEX_UNIT = tex_unit;
        this.mHasDepthBuffer = use_depth_buffer;
        this.mAdjustPower2 = adjust_power2;
        this.createFrameBuffer(width, height);
        int tex = tex_id;
        if (tex < 0) {
            tex = this.genTexture(tex_target, tex_unit, this.mTexWidth, this.mTexHeight);
        }
        this.assignTexture(tex, width, height);
        this.mWrappedTexture = tex_id > -1;
        this.setViewPort(0, 0, this.mWidth, this.mHeight);
    }

    @Override
    public void release() {
        this.releaseFrameBuffer();
    }

    @Override
    public boolean isValid() {
        return this.mFrameBufferObj >= 0;
    }

    @Override
    public boolean isOES() {
        return this.TEX_TARGET == 36197;
    }

    @Override
    public int getTexTarget() {
        return this.TEX_TARGET;
    }

    @Override
    public int getTexUnit() {
        return this.TEX_UNIT;
    }

    @Override
    public int getTexId() {
        return this.mFBOTexId;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getTexWidth() {
        return this.mTexWidth;
    }

    @Override
    public int getTexHeight() {
        return this.mTexHeight;
    }

    @Override
    @Size(min=16L)
    @NonNull
    public float[] copyTexMatrix() {
        System.arraycopy(this.mTexMatrix, 0, this.mResultMatrix, 0, 16);
        return this.mResultMatrix;
    }

    @Override
    public void copyTexMatrix(@NonNull @Size(min=16L) float[] matrix, int offset) {
        System.arraycopy(this.mTexMatrix, 0, matrix, offset, this.mTexMatrix.length);
    }

    @Override
    @Size(min=16L)
    @NonNull
    public float[] getTexMatrix() {
        return this.mTexMatrix;
    }

    public abstract void bindTexture();

    public abstract void assignTexture(int var1, int var2, int var3);

    protected abstract void createFrameBuffer(int var1, int var2);

    protected abstract void releaseFrameBuffer();

    protected abstract int genTexture(int var1, int var2, int var3, int var4);

    @RequiresApi(api=18)
    private static class GLSurfaceES3
    extends GLSurface {
        private GLSurfaceES3(int tex_target, int tex_unit, int tex_id, int width, int height, boolean use_depth_buffer, boolean adjust_power2) {
            super(true, tex_target, tex_unit, tex_id, width, height, use_depth_buffer, adjust_power2);
        }

        @Override
        public void bindTexture() {
            GLES30.glActiveTexture((int)this.TEX_UNIT);
            GLES30.glBindTexture((int)this.TEX_TARGET, (int)this.mFBOTexId);
        }

        @Override
        public void makeCurrent() {
            GLES30.glActiveTexture((int)this.TEX_UNIT);
            GLES30.glBindTexture((int)this.TEX_TARGET, (int)this.mFBOTexId);
            GLES30.glBindFramebuffer((int)36160, (int)this.mFrameBufferObj);
            this.setViewPort(this.viewPortX, this.viewPortY, this.viewPortWidth, this.viewPortHeight);
        }

        @Override
        public void setViewPort(int x, int y, int width, int height) {
            this.viewPortX = x;
            this.viewPortY = y;
            this.viewPortWidth = width;
            this.viewPortHeight = height;
            GLES30.glViewport((int)x, (int)y, (int)width, (int)height);
        }

        @Override
        public void swap() {
            GLES30.glBindFramebuffer((int)36160, (int)0);
            GLES30.glActiveTexture((int)this.TEX_UNIT);
            GLES30.glBindTexture((int)this.TEX_TARGET, (int)0);
        }

        @Override
        public void assignTexture(int texture_name, int width, int height) {
            int status;
            if (width > this.mTexWidth || height > this.mTexHeight) {
                this.releaseFrameBuffer();
                this.createFrameBuffer(width, height);
            }
            if (!this.mWrappedTexture && this.mFBOTexId > -1) {
                GLUtils.deleteTex(this.mFBOTexId);
            }
            this.mWrappedTexture = true;
            this.mFBOTexId = texture_name;
            GLES30.glActiveTexture((int)this.TEX_UNIT);
            GLES30.glBindFramebuffer((int)36160, (int)this.mFrameBufferObj);
            GLUtils.checkGlError("glBindFramebuffer " + this.mFrameBufferObj);
            GLES30.glFramebufferTexture2D((int)36160, (int)36064, (int)this.TEX_TARGET, (int)this.mFBOTexId, (int)0);
            GLUtils.checkGlError("glFramebufferTexture2D");
            if (this.mHasDepthBuffer) {
                GLES30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.mDepthBufferObj);
                GLUtils.checkGlError("glFramebufferRenderbuffer");
            }
            if ((status = GLES30.glCheckFramebufferStatus((int)36160)) != 36053) {
                throw new RuntimeException("Framebuffer not complete, status=" + status);
            }
            GLES30.glBindFramebuffer((int)36160, (int)0);
            Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
            this.mTexMatrix[0] = (float)width / (float)this.mTexWidth;
            this.mTexMatrix[5] = (float)height / (float)this.mTexHeight;
        }

        @Override
        public void loadBitmap(@NonNull Bitmap bitmap) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (width > this.mTexWidth || height > this.mTexHeight) {
                this.releaseFrameBuffer();
                this.createFrameBuffer(width, height);
            }
            GLES30.glActiveTexture((int)this.TEX_UNIT);
            GLES30.glBindTexture((int)this.TEX_TARGET, (int)this.mFBOTexId);
            android.opengl.GLUtils.texImage2D((int)this.TEX_TARGET, (int)0, (Bitmap)bitmap, (int)0);
            GLES30.glBindTexture((int)this.TEX_TARGET, (int)0);
            Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
            this.mTexMatrix[0] = (float)width / (float)this.mTexWidth;
            this.mTexMatrix[5] = (float)height / (float)this.mTexHeight;
        }

        @Override
        protected void createFrameBuffer(int width, int height) {
            int[] ids = new int[1];
            if (this.mAdjustPower2) {
                int h;
                int w;
                for (w = 1; w < width; w <<= 1) {
                }
                for (h = 1; h < height; h <<= 1) {
                }
                if (this.mTexWidth != w || this.mTexHeight != h) {
                    this.mTexWidth = w;
                    this.mTexHeight = h;
                }
            } else {
                this.mTexWidth = width;
                this.mTexHeight = height;
            }
            this.mWidth = width;
            this.mHeight = height;
            if (this.mHasDepthBuffer) {
                GLES30.glGenRenderbuffers((int)1, (int[])ids, (int)0);
                this.mDepthBufferObj = ids[0];
                GLES30.glBindRenderbuffer((int)36161, (int)this.mDepthBufferObj);
                GLES30.glRenderbufferStorage((int)36161, (int)33189, (int)this.mTexWidth, (int)this.mTexHeight);
            }
            GLES30.glGenFramebuffers((int)1, (int[])ids, (int)0);
            GLUtils.checkGlError("glGenFramebuffers");
            this.mFrameBufferObj = ids[0];
            GLES30.glBindFramebuffer((int)36160, (int)this.mFrameBufferObj);
            GLUtils.checkGlError("glBindFramebuffer " + this.mFrameBufferObj);
            GLES30.glBindFramebuffer((int)36160, (int)0);
        }

        @Override
        protected void releaseFrameBuffer() {
            int[] names = new int[1];
            if (this.mDepthBufferObj > -1) {
                names[0] = this.mDepthBufferObj;
                GLES30.glDeleteRenderbuffers((int)1, (int[])names, (int)0);
                this.mDepthBufferObj = -1;
            }
            if (!this.mWrappedTexture && this.mFBOTexId > -1) {
                GLUtils.deleteTex(this.mFBOTexId);
                this.mFBOTexId = -1;
            }
            if (this.mFrameBufferObj > -1) {
                names[0] = this.mFrameBufferObj;
                GLES30.glDeleteFramebuffers((int)1, (int[])names, (int)0);
                this.mFrameBufferObj = -1;
            }
        }

        @Override
        protected int genTexture(int tex_target, int tex_unit, int tex_width, int tex_height) {
            int tex_name = GLUtils.initTex(tex_target, tex_unit, 9729, 9729, 33071);
            GLES30.glTexImage2D((int)tex_target, (int)0, (int)6408, (int)tex_width, (int)tex_height, (int)0, (int)6408, (int)5121, null);
            GLUtils.checkGlError("glTexImage2D");
            this.mWrappedTexture = false;
            return tex_name;
        }
    }

    private static class GLSurfaceES2
    extends GLSurface {
        private GLSurfaceES2(int tex_target, int tex_unit, int tex_id, int width, int height, boolean use_depth_buffer, boolean adjust_power2) {
            super(false, tex_target, tex_unit, tex_id, width, height, use_depth_buffer, adjust_power2);
        }

        @Override
        public void bindTexture() {
            GLES20.glActiveTexture((int)this.TEX_UNIT);
            GLES20.glBindTexture((int)this.TEX_TARGET, (int)this.mFBOTexId);
        }

        @Override
        public void makeCurrent() {
            GLES20.glActiveTexture((int)this.TEX_UNIT);
            GLES20.glBindTexture((int)this.TEX_TARGET, (int)this.mFBOTexId);
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferObj);
            this.setViewPort(this.viewPortX, this.viewPortY, this.viewPortWidth, this.viewPortHeight);
        }

        @Override
        public void setViewPort(int x, int y, int width, int height) {
            this.viewPortX = x;
            this.viewPortY = y;
            this.viewPortWidth = width;
            this.viewPortHeight = height;
            GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
        }

        @Override
        public void swap() {
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GLES20.glActiveTexture((int)this.TEX_UNIT);
            GLES20.glBindTexture((int)this.TEX_TARGET, (int)0);
        }

        @Override
        public void assignTexture(int texture_name, int width, int height) {
            int status;
            if (width > this.mTexWidth || height > this.mTexHeight) {
                this.releaseFrameBuffer();
                this.createFrameBuffer(width, height);
            }
            if (!this.mWrappedTexture && this.mFBOTexId > -1) {
                GLUtils.deleteTex(this.mFBOTexId);
            }
            this.mWrappedTexture = true;
            this.mFBOTexId = texture_name;
            GLES20.glActiveTexture((int)this.TEX_UNIT);
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferObj);
            GLUtils.checkGlError("glBindFramebuffer " + this.mFrameBufferObj);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)this.TEX_TARGET, (int)this.mFBOTexId, (int)0);
            GLUtils.checkGlError("glFramebufferTexture2D");
            if (this.mHasDepthBuffer) {
                GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.mDepthBufferObj);
                GLUtils.checkGlError("glFramebufferRenderbuffer");
            }
            if ((status = GLES20.glCheckFramebufferStatus((int)36160)) != 36053) {
                throw new RuntimeException("Framebuffer not complete, status=" + status);
            }
            GLES20.glBindFramebuffer((int)36160, (int)0);
            Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
            this.mTexMatrix[0] = (float)width / (float)this.mTexWidth;
            this.mTexMatrix[5] = (float)height / (float)this.mTexHeight;
        }

        @Override
        public void loadBitmap(@NonNull Bitmap bitmap) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (width > this.mTexWidth || height > this.mTexHeight) {
                this.releaseFrameBuffer();
                this.createFrameBuffer(width, height);
            }
            GLES20.glActiveTexture((int)this.TEX_UNIT);
            GLES20.glBindTexture((int)this.TEX_TARGET, (int)this.mFBOTexId);
            android.opengl.GLUtils.texImage2D((int)this.TEX_TARGET, (int)0, (Bitmap)bitmap, (int)0);
            GLES20.glBindTexture((int)this.TEX_TARGET, (int)0);
            Matrix.setIdentityM((float[])this.mTexMatrix, (int)0);
            this.mTexMatrix[0] = (float)width / (float)this.mTexWidth;
            this.mTexMatrix[5] = (float)height / (float)this.mTexHeight;
        }

        @Override
        protected void createFrameBuffer(int width, int height) {
            int[] ids = new int[1];
            if (this.mAdjustPower2) {
                int h;
                int w;
                for (w = 1; w < width; w <<= 1) {
                }
                for (h = 1; h < height; h <<= 1) {
                }
                if (this.mTexWidth != w || this.mTexHeight != h) {
                    this.mTexWidth = w;
                    this.mTexHeight = h;
                }
            } else {
                this.mTexWidth = width;
                this.mTexHeight = height;
            }
            this.mWidth = width;
            this.mHeight = height;
            if (this.mHasDepthBuffer) {
                GLES20.glGenRenderbuffers((int)1, (int[])ids, (int)0);
                this.mDepthBufferObj = ids[0];
                GLES20.glBindRenderbuffer((int)36161, (int)this.mDepthBufferObj);
                GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)this.mTexWidth, (int)this.mTexHeight);
            }
            GLES20.glGenFramebuffers((int)1, (int[])ids, (int)0);
            GLUtils.checkGlError("glGenFramebuffers");
            this.mFrameBufferObj = ids[0];
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferObj);
            GLUtils.checkGlError("glBindFramebuffer " + this.mFrameBufferObj);
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }

        @Override
        protected void releaseFrameBuffer() {
            int[] names = new int[1];
            if (this.mDepthBufferObj > -1) {
                names[0] = this.mDepthBufferObj;
                GLES20.glDeleteRenderbuffers((int)1, (int[])names, (int)0);
                this.mDepthBufferObj = -1;
            }
            if (!this.mWrappedTexture && this.mFBOTexId > -1) {
                GLUtils.deleteTex(this.mFBOTexId);
                this.mFBOTexId = -1;
            }
            if (this.mFrameBufferObj > -1) {
                names[0] = this.mFrameBufferObj;
                GLES20.glDeleteFramebuffers((int)1, (int[])names, (int)0);
                this.mFrameBufferObj = -1;
            }
        }

        @Override
        protected int genTexture(int tex_target, int tex_unit, int tex_width, int tex_height) {
            int tex_name = GLUtils.initTex(tex_target, tex_unit, 9729, 9729, 33071);
            GLES20.glTexImage2D((int)tex_target, (int)0, (int)6408, (int)tex_width, (int)tex_height, (int)0, (int)6408, (int)5121, null);
            GLUtils.checkGlError("glTexImage2D");
            this.mWrappedTexture = false;
            return tex_name;
        }
    }
}

