/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import androidx.annotation.NonNull;
import com.serenegiant.media.IAudioSampler;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class SoundCheck {
    private static SoundCheck mSoundCheck = null;
    protected IAudioSampler mAudioSampler;
    private SoundCheckCallback mSoundCheckCallback;
    private final Object mSoundSync = new Object();
    private volatile boolean mBusy;
    private volatile boolean mSoundCheckRunning;
    private short[] mSoundBuffer;
    private int mSoundBufferSize;
    private static final long MIN_SOUND_CHECK_INTERVAL_US = 300000L;
    private final IAudioSampler.SoundSamplerCallback mSoundSamplerCallback = new IAudioSampler.SoundSamplerCallback(){
        private long prevSamplingUs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onData(@NonNull ByteBuffer buffer, int size, long presentationTimeUs) {
            if (SoundCheck.this.mBusy || presentationTimeUs - this.prevSamplingUs < 300000L) {
                return;
            }
            SoundCheck.this.mBusy = true;
            Object object = SoundCheck.this.mSoundSync;
            synchronized (object) {
                this.prevSamplingUs = presentationTimeUs;
                SoundCheck.this.mSoundBufferSize = size / 2;
                ShortBuffer buf = buffer.asShortBuffer();
                if (SoundCheck.this.mSoundBuffer == null || SoundCheck.this.mSoundBuffer.length < SoundCheck.this.mSoundBufferSize) {
                    SoundCheck.access$302(SoundCheck.this, new short[SoundCheck.this.mSoundBufferSize]);
                }
                buf.get(SoundCheck.this.mSoundBuffer, 0, SoundCheck.this.mSoundBufferSize);
                SoundCheck.this.mSoundSync.notifyAll();
            }
        }

        public void onError(Exception e) {
        }
    };
    private final Runnable mSoundCheckTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SoundCheck.this.mSoundCheckCallback != null) {
                try {
                    SoundCheck.this.mSoundCheckCallback.onStart();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            while (SoundCheck.this.mSoundCheckRunning) {
                Object object = SoundCheck.this.mSoundSync;
                synchronized (object) {
                    if (SoundCheck.this.mBusy) {
                        if (SoundCheck.this.mSoundCheckCallback != null) {
                            try {
                                SoundCheck.this.mSoundCheckCallback.onCheck(SoundCheck.calcAmplitude(SoundCheck.this.mSoundBuffer, SoundCheck.this.mSoundBufferSize));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        SoundCheck.this.mBusy = false;
                    } else {
                        try {
                            SoundCheck.this.mSoundSync.wait(300L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
            if (SoundCheck.this.mSoundCheckCallback != null) {
                try {
                    SoundCheck.this.mSoundCheckCallback.onStop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    public static synchronized SoundCheck getInstance() {
        if (mSoundCheck == null) {
            mSoundCheck = new SoundCheck();
        }
        return mSoundCheck;
    }

    private SoundCheck() {
    }

    public void setAudioSampler(IAudioSampler sampler, SoundCheckCallback callback) {
        if (this.mAudioSampler != sampler) {
            this.mSoundCheckRunning = false;
            if (this.mAudioSampler != null) {
                this.mAudioSampler.removeCallback(this.mSoundSamplerCallback);
            }
            this.mAudioSampler = sampler;
            this.mSoundCheckCallback = callback;
            if (sampler != null) {
                this.mAudioSampler.addCallback(this.mSoundSamplerCallback);
                this.mSoundCheckRunning = true;
                new Thread(this.mSoundCheckTask, "SoundCheck").start();
            }
        }
    }

    public IAudioSampler getAudioSampler() {
        return this.mAudioSampler;
    }

    private static final int calcAmplitude(short[] buffer, int size) {
        double amp = 0.0;
        for (int i = 0; i < size; ++i) {
            short a = buffer[i];
            amp += (double)(a * a);
        }
        if ((amp = Math.sqrt(amp / (double)size)) == 0.0) {
            amp = 1.0;
        }
        return (int)(Math.log10(amp) * 30.0) - 30;
    }

    static /* synthetic */ short[] access$302(SoundCheck x0, short[] x1) {
        x0.mSoundBuffer = x1;
        return x1;
    }

    public static interface SoundCheckCallback {
        public void onStart();

        public void onStop();

        public void onCheck(int var1);
    }
}

