/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.IFrameCallback;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.media.MediaCodecUtils;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.usb.uvc.FrameCallbackPipeline;
import com.serenegiant.usb.uvc.TranscodeH264;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=18)
public class TranscodeH264PipelineSource
extends TranscodeH264 {
    private static final boolean DEBUG = false;
    private static final String TAG = TranscodeH264PipelineSource.class.getSimpleName();
    private final FrameCallbackPipeline mFrameCallbackPipeline = new FrameCallbackPipeline();

    public TranscodeH264PipelineSource() {
        this(0, null, null);
    }

    public TranscodeH264PipelineSource(int prefixOptions) {
        this(prefixOptions, null, null);
    }

    public TranscodeH264PipelineSource(int prefixOptions, TranscodeH264.TranscodeH264Listener listener, @Nullable VideoConfig config) {
        super(prefixOptions, listener, config);
        this.mFrameCallbackPipeline.setFrameCallback(new IFrameCallback(){

            @Override
            public void onFrame(@NonNull ByteBuffer frame, int width, int height, long presentationTimeUs, int raw_frame_t, int flags) {
            }
        }, RawFrameType.RAW_FRAME_UNKNOWN);
    }

    @Override
    public void release() {
        try {
            this.mFrameCallbackPipeline.setFrameCallback(null, RawFrameType.RAW_FRAME_UNKNOWN);
            this.mFrameCallbackPipeline.release();
        }
        finally {
            super.release();
        }
    }

    @Override
    protected void onCreateEncoder(@NonNull MediaCodec mVideoEncoder) {
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    protected MediaCodec createEncoder(@NonNull VideoConfig config, int width, int height, int frameRate, float bpp, int iFrameIntervals, long repeatIntervalUs) throws IOException {
        MediaCodecInfo codecInfo = MediaCodecUtils.selectVideoEncoder((String)"video/avc");
        if (codecInfo == null) {
            throw new IOException("Unable to find an appropriate codec for video/avc");
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)width, (int)height);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", config.getBitrate(width, height, frameRate, bpp));
        format.setInteger("frame-rate", frameRate);
        format.setInteger("i-frame-interval", iFrameIntervals);
        if (BuildCheck.isKitKat() && repeatIntervalUs > 0L) {
            format.setLong("repeat-previous-frame-after", repeatIntervalUs);
        }
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"video/avc");
        encoder.configure(format, null, null, 1);
        return encoder;
    }
}

