/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.serenegiant.usb.NativeLibLoader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Keep
public abstract class IPipeline {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_RELEASING = 10;
    public static final int STATE_INITIALIZED = 20;
    public static final int STATE_STARTING = 30;
    public static final int STATE_RUNNING = 40;
    public static final int STATE_STOPPING = 50;
    public static final int STATE_STOPPED = 60;
    protected static final int PIPELINE_TYPE_SIMPLE_BUFFERED = 0;
    protected static final int PIPELINE_TYPE_UVC_CONTROL = 100;
    protected static final int PIPELINE_TYPE_PTS_CALC = 200;
    protected static final int PIPELINE_TYPE_CALLBACK = 300;
    protected static final int PIPELINE_TYPE_CALLBACK_NATIVE = 310;
    protected static final int PIPELINE_TYPE_DISTRIBUTE = 400;
    protected static final int PIPELINE_TYPE_PREVIEW = 500;
    protected static final int PIPELINE_TYPE_PREVIEW_GL_RENDERER_UVC = 510;
    protected static final int PIPELINE_TYPE_PREVIEW_GL_RENDERER_UPC = 520;
    protected static final int PIPELINE_TYPE_GL_PREVIEW = 530;
    protected static final int PIPELINE_TYPE_CONVERT = 600;
    protected static final int PIPELINE_TYPE_CAPTURE = 700;
    protected final int mType;
    protected long mNativePtr;

    public IPipeline(int type) {
        this.mType = type;
    }

    public abstract int getState();

    public abstract void setPipeline(@Nullable IPipeline var1);

    public abstract void start();

    public abstract void stop();

    public abstract void release();

    public boolean isRunning() {
        int state = this.getState();
        return state == 30 || state == 40;
    }

    public boolean isReleased() {
        int state = this.getState();
        return state <= 10;
    }

    static {
        NativeLibLoader.loadNative();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PipelineType {
    }
}

