/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.serenegiant.media.AbstractVideoEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.MediaCodecUtils;
import com.serenegiant.media.MediaReaper;
import com.serenegiant.media.Recorder;
import com.serenegiant.system.Time;
import java.nio.ByteBuffer;

@Keep
public final class VideoEncoder
extends AbstractVideoEncoder {
    private static final String TAG = VideoEncoder.class.getSimpleName();
    private static boolean isLoaded = false;
    protected long mNativePtr;
    private final boolean mAlign16;
    private final boolean mAdjustPts;
    private int mColorFormat;
    private long firstPresentationTimeUs;
    private long firstSysTimeUs;

    public VideoEncoder(Recorder recorder, EncoderListener listener, boolean align16) {
        this(recorder, listener, align16, true);
    }

    public VideoEncoder(Recorder recorder, EncoderListener listener, boolean align16, boolean adjustPts) {
        super("video/avc", (IRecorder)recorder, listener);
        this.mAlign16 = align16;
        this.mAdjustPts = adjustPts;
        this.mNativePtr = this.nativeCreate();
    }

    protected boolean internalPrepare(@NonNull MediaReaper.ReaperListener listener) throws Exception {
        this.mIsCapturing = true;
        MediaCodecInfo codecInfo = MediaCodecUtils.selectVideoEncoder((String)"video/avc");
        if (codecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for video/avc");
            return true;
        }
        boolean mayFail = this.mWidth >= 1000 || this.mHeight >= 1000;
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)this.mWidth, (int)this.mHeight);
        this.mColorFormat = MediaCodecUtils.selectColorFormat((MediaCodecInfo)codecInfo, (String)"video/avc");
        format.setInteger("color-format", this.mColorFormat);
        format.setInteger("bitrate", this.mBitRate > 0 ? this.mBitRate : this.getConfig().getBitrate(this.mWidth, this.mHeight));
        format.setInteger("frame-rate", this.mFramerate > 0 ? this.mFramerate : this.getConfig().captureFps());
        format.setInteger("i-frame-interval", this.mIFrameIntervals > 0 ? this.mIFrameIntervals : this.getConfig().calcIFrameIntervals());
        Log.d((String)TAG, (String)("format: " + format));
        this.mMediaCodec = MediaCodec.createEncoderByType((String)"video/avc");
        this.mMediaCodec.configure(format, null, null, 1);
        this.mMediaCodec.start();
        if (this.mAlign16) {
            if (this.mWidth / 16 * 16 != this.mWidth) {
                this.mWidth = (this.mWidth / 16 + 1) * 16;
            }
            if (this.mHeight / 16 * 16 != this.mHeight) {
                this.mHeight = (this.mHeight / 16 + 1) * 16;
            }
        }
        VideoEncoder.nativePrepare(this.mNativePtr, this.mWidth, this.mHeight, MediaCodecUtils.selectColorFormat((MediaCodecInfo)codecInfo, (String)"video/avc"));
        return mayFail;
    }

    public void start() {
        super.start();
        this.firstPresentationTimeUs = -1L;
    }

    public void stop() {
        if (this.mNativePtr != 0L) {
            VideoEncoder.nativeStop(this.mNativePtr);
        }
        super.stop();
    }

    public void release() {
        this.stop();
        if (this.mNativePtr != 0L) {
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
        super.release();
    }

    protected synchronized boolean startRecorder(@NonNull IRecorder recorder, @NonNull MediaFormat outFormat) {
        int h;
        int w;
        try {
            w = outFormat.getInteger("width");
        }
        catch (Exception e) {
            w = this.mWidth;
        }
        try {
            h = outFormat.getInteger("height");
        }
        catch (Exception e) {
            h = this.mHeight;
        }
        VideoEncoder.nativeResize(this.mNativePtr, w, h, this.mColorFormat);
        return super.startRecorder(recorder, outFormat);
    }

    protected void stopRecorder(IRecorder recorder) {
        VideoEncoder.nativeStop(this.mNativePtr);
        super.stopRecorder(recorder);
    }

    public int getCaptureFormat() {
        return -1;
    }

    public void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        long pts = presentationTimeUs;
        if (this.mAdjustPts) {
            long delta;
            if (this.firstPresentationTimeUs <= 0L) {
                this.firstPresentationTimeUs = presentationTimeUs;
                this.firstSysTimeUs = Time.nanoTime() / 1000L;
            }
            pts = this.firstSysTimeUs + ((delta = presentationTimeUs - this.firstPresentationTimeUs) > 0L ? delta : 16666L);
        }
        super.encode(buffer, length, pts);
    }

    private native long nativeCreate();

    private native void nativeDestroy(long var1);

    private static native int nativePrepare(long var0, int var2, int var3, int var4);

    private static native int nativeResize(long var0, int var2, int var3, int var4);

    private static native int nativeStop(long var0);

    static {
        if (!isLoaded) {
            System.loadLibrary("c++_shared");
            System.loadLibrary("jpeg-turbo2x");
            System.loadLibrary("png16");
            System.loadLibrary("common");
            System.loadLibrary("media-utils");
            System.loadLibrary("media-backport");
            isLoaded = true;
        }
    }
}

