/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.os.Handler;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.camera.CameraState;
import com.serenegiant.camera.ICamera;
import com.serenegiant.camera.ICameraCallback;
import com.serenegiant.utils.HandlerThreadHandler;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractCamera
extends CameraState
implements ICamera {
    private static final boolean DEBUG = false;
    private static final String TAG = AbstractCamera.class.getSimpleName();
    private final Set<ICameraCallback> mCallbacks = new CopyOnWriteArraySet<ICameraCallback>();
    private Handler mCallbackHandler = HandlerThreadHandler.createHandler((String)"CallbackHandler");
    private long mCallbackHandlerId = -1L;

    @Override
    public void release() {
        block5: {
            this.writeLock();
            try {
                this.mCallbackHandlerId = -1L;
                if (this.mCallbackHandler == null) break block5;
                try {
                    this.mCallbackHandler.getLooper().quit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mCallbackHandler = null;
            }
            finally {
                this.writeUnlock();
            }
        }
        super.release();
    }

    public void registerCallback(ICameraCallback callback) {
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
    }

    public boolean unregisterCallback(ICameraCallback callback) {
        if (callback != null) {
            try {
                this.mCallbacks.remove(callback);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mCallbacks.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void queueCallback(Runnable task, long delayMillis) {
        block9: {
            this.readLock();
            try {
                if (task == null || this.mCallbackHandler == null) {
                    return;
                }
                try {
                    this.mCallbackHandler.removeCallbacks(task);
                    if (delayMillis > 0L) {
                        this.mCallbackHandler.postDelayed(task, delayMillis);
                        break block9;
                    }
                    if (this.mCallbackHandlerId == Thread.currentThread().getId()) {
                        task.run();
                        break block9;
                    }
                    this.mCallbackHandler.post(task);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                this.readUnlock();
            }
        }
    }

    protected final void removeCallback(Runnable task) {
        this.readLock();
        try {
            if (task == null || this.mCallbackHandler == null) {
                return;
            }
            try {
                this.mCallbackHandler.removeCallbacks(task);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.readUnlock();
        }
    }

    protected final void removeCallbackAll() {
        this.readLock();
        try {
            if (this.mCallbackHandler != null) {
                try {
                    this.mCallbackHandler.removeCallbacksAndMessages(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.readUnlock();
        }
    }

    protected Set<ICameraCallback> getCallbacks() {
        return this.mCallbacks;
    }

    protected void callOnConnected() {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onConnect(AbstractCamera.this);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnDisconnected() {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onDisconnect(AbstractCamera.this);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnStartRecording(final long startTimeMs) {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onStartRecording(AbstractCamera.this, startTimeMs);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnStopRecording() {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onStopRecording(AbstractCamera.this);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnStartTimelapse(final long startTimeMs) {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onStartTimelapse(AbstractCamera.this, startTimeMs);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnStopTimelapse() {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onStopTimelapse(AbstractCamera.this);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnCaptureStillImage(final DocumentFile outputPath) {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onCaptureStillImage(AbstractCamera.this, outputPath);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnError(final Throwable t) {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onError(AbstractCamera.this, t);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnStartSoundLevel() {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onStartSoundLevel(AbstractCamera.this);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnStopSoundLevel() {
        if (!this.isInitialized()) {
            return;
        }
        this.queueCallback(new Runnable(){

            @Override
            public void run() {
                for (ICameraCallback callback : AbstractCamera.this.mCallbacks) {
                    try {
                        callback.onStopSoundLevel(AbstractCamera.this);
                    }
                    catch (Exception e) {
                        AbstractCamera.this.mCallbacks.remove(callback);
                    }
                }
            }
        }, 0L);
    }

    protected void callOnCheckSoundLevel(int amplitude) {
        for (ICameraCallback callback : this.mCallbacks) {
            try {
                callback.onCheckSoundLevel(this, amplitude);
            }
            catch (Exception e) {
                this.mCallbacks.remove(callback);
            }
        }
    }
}

