/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Notification;
import android.app.NotificationChannel;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;

public class NotificationChannelCompat {
    public static final String DEFAULT_CHANNEL_ID = "miscellaneous";
    private static final boolean DEFAULT_SHOW_BADGE = true;
    private static final int DEFAULT_LIGHT_COLOR = 0;
    @NonNull
    final String mId;
    CharSequence mName;
    int mImportance;
    String mDescription;
    String mGroupId;
    boolean mShowBadge = true;
    Uri mSound = Settings.System.DEFAULT_NOTIFICATION_URI;
    AudioAttributes mAudioAttributes;
    boolean mLights;
    int mLightColor = 0;
    boolean mVibrationEnabled;
    long[] mVibrationPattern;
    String mParentId;
    String mConversationId;
    private boolean mBypassDnd;
    private int mLockscreenVisibility;
    private boolean mCanBubble;
    private boolean mImportantConversation;

    NotificationChannelCompat(@NonNull String id, int importance) {
        this.mId = Preconditions.checkNotNull(id);
        this.mImportance = importance;
        if (Build.VERSION.SDK_INT >= 21) {
            this.mAudioAttributes = Notification.AUDIO_ATTRIBUTES_DEFAULT;
        }
    }

    @RequiresApi(value=26)
    NotificationChannelCompat(@NonNull NotificationChannel channel) {
        this(channel.getId(), channel.getImportance());
        this.mName = channel.getName();
        this.mDescription = channel.getDescription();
        this.mGroupId = channel.getGroup();
        this.mShowBadge = channel.canShowBadge();
        this.mSound = channel.getSound();
        this.mAudioAttributes = channel.getAudioAttributes();
        this.mLights = channel.shouldShowLights();
        this.mLightColor = channel.getLightColor();
        this.mVibrationEnabled = channel.shouldVibrate();
        this.mVibrationPattern = channel.getVibrationPattern();
        if (Build.VERSION.SDK_INT >= 30) {
            this.mParentId = channel.getParentChannelId();
            this.mConversationId = channel.getConversationId();
        }
        this.mBypassDnd = channel.canBypassDnd();
        this.mLockscreenVisibility = channel.getLockscreenVisibility();
        if (Build.VERSION.SDK_INT >= 29) {
            this.mCanBubble = channel.canBubble();
        }
        if (Build.VERSION.SDK_INT >= 30) {
            this.mImportantConversation = channel.isImportantConversation();
        }
    }

    NotificationChannel getNotificationChannel() {
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        NotificationChannel channel = new NotificationChannel(this.mId, this.mName, this.mImportance);
        channel.setDescription(this.mDescription);
        channel.setGroup(this.mGroupId);
        channel.setShowBadge(this.mShowBadge);
        channel.setSound(this.mSound, this.mAudioAttributes);
        channel.enableLights(this.mLights);
        channel.setLightColor(this.mLightColor);
        channel.setVibrationPattern(this.mVibrationPattern);
        channel.enableVibration(this.mVibrationEnabled);
        if (Build.VERSION.SDK_INT >= 30 && this.mParentId != null && this.mConversationId != null) {
            channel.setConversationId(this.mParentId, this.mConversationId);
        }
        return channel;
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder(this.mId, this.mImportance).setName(this.mName).setDescription(this.mDescription).setGroup(this.mGroupId).setShowBadge(this.mShowBadge).setSound(this.mSound, this.mAudioAttributes).setLightsEnabled(this.mLights).setLightColor(this.mLightColor).setVibrationEnabled(this.mVibrationEnabled).setVibrationPattern(this.mVibrationPattern).setConversationId(this.mParentId, this.mConversationId);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public CharSequence getName() {
        return this.mName;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    public int getImportance() {
        return this.mImportance;
    }

    @Nullable
    public Uri getSound() {
        return this.mSound;
    }

    @Nullable
    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    public boolean shouldShowLights() {
        return this.mLights;
    }

    public int getLightColor() {
        return this.mLightColor;
    }

    public boolean shouldVibrate() {
        return this.mVibrationEnabled;
    }

    @Nullable
    public long[] getVibrationPattern() {
        return this.mVibrationPattern;
    }

    public boolean canShowBadge() {
        return this.mShowBadge;
    }

    @Nullable
    public String getGroup() {
        return this.mGroupId;
    }

    @Nullable
    public String getParentChannelId() {
        return this.mParentId;
    }

    @Nullable
    public String getConversationId() {
        return this.mConversationId;
    }

    public boolean canBypassDnd() {
        return this.mBypassDnd;
    }

    public int getLockscreenVisibility() {
        return this.mLockscreenVisibility;
    }

    public boolean canBubble() {
        return this.mCanBubble;
    }

    public boolean isImportantConversation() {
        return this.mImportantConversation;
    }

    public static class Builder {
        private final NotificationChannelCompat mChannel;

        public Builder(@NonNull String id, int importance) {
            this.mChannel = new NotificationChannelCompat(id, importance);
        }

        @NonNull
        public Builder setName(@Nullable CharSequence name) {
            this.mChannel.mName = name;
            return this;
        }

        @NonNull
        public Builder setImportance(int importance) {
            this.mChannel.mImportance = importance;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable String description) {
            this.mChannel.mDescription = description;
            return this;
        }

        @NonNull
        public Builder setGroup(@Nullable String groupId) {
            this.mChannel.mGroupId = groupId;
            return this;
        }

        @NonNull
        public Builder setShowBadge(boolean showBadge) {
            this.mChannel.mShowBadge = showBadge;
            return this;
        }

        @NonNull
        public Builder setSound(@Nullable Uri sound, @Nullable AudioAttributes audioAttributes) {
            this.mChannel.mSound = sound;
            this.mChannel.mAudioAttributes = audioAttributes;
            return this;
        }

        @NonNull
        public Builder setLightsEnabled(boolean lights) {
            this.mChannel.mLights = lights;
            return this;
        }

        @NonNull
        public Builder setLightColor(int argb) {
            this.mChannel.mLightColor = argb;
            return this;
        }

        @NonNull
        public Builder setVibrationEnabled(boolean vibration) {
            this.mChannel.mVibrationEnabled = vibration;
            return this;
        }

        @NonNull
        public Builder setVibrationPattern(@Nullable long[] vibrationPattern) {
            this.mChannel.mVibrationEnabled = vibrationPattern != null && vibrationPattern.length > 0;
            this.mChannel.mVibrationPattern = vibrationPattern;
            return this;
        }

        @NonNull
        public Builder setConversationId(@NonNull String parentChannelId, @NonNull String conversationId) {
            if (Build.VERSION.SDK_INT >= 30) {
                this.mChannel.mParentId = parentChannelId;
                this.mChannel.mConversationId = conversationId;
            }
            return this;
        }

        @NonNull
        public NotificationChannelCompat build() {
            return this.mChannel;
        }
    }
}

