/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import android.util.Log;
import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.BluetoothStreamManager;
import com.tony.bluetoothunityapi.CharArrayWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BluetoothLengthStreamManager
extends BluetoothStreamManager {
    private List<Byte> messageBuffer;
    private int length = 0;
    private int remaining = 0;
    private STATE state = STATE.PRE1;

    public BluetoothLengthStreamManager(BluetoothHelper helper) {
        super(helper);
        this.messageBuffer = new ArrayList<Byte>();
    }

    @Override
    public void Listen() {
        this.transceiver.listen();
    }

    private byte[] read(byte[] in, int offset, int r_length) throws NullPointerException {
        int length = in.length;
        int l = r_length < length - offset ? r_length : length - offset;
        if (l == 0) {
            throw new NullPointerException();
        }
        return Arrays.copyOfRange(in, offset, l + offset);
    }

    @Override
    public void OnMessageReceived(byte[] buff) {
        byte[] buffer = null;
        int offset = 0;
        while (offset < buff.length) {
            try {
                switch (this.state) {
                    case PRE1: {
                        buffer = this.read(buff, offset, 1);
                        if (buffer[0] == 85) {
                            this.state = STATE.PRE2;
                        }
                        Log.d((String)"BluetoothAPI", (String)("State 1 read " + buffer[0]));
                        break;
                    }
                    case PRE2: {
                        buffer = this.read(buff, offset, 1);
                        this.state = buffer[0] == 85 ? STATE.LENGTH1 : STATE.PRE1;
                        Log.d((String)"BluetoothAPI", (String)("State 2 read " + buffer[0]));
                        break;
                    }
                    case LENGTH1: {
                        buffer = this.read(buff, offset, 1);
                        this.length = buffer[0] << 8 & 0xFF00;
                        this.state = STATE.LENGTH2;
                        Log.d((String)"BluetoothAPI", (String)("State 3 " + buffer[0]));
                        break;
                    }
                    case LENGTH2: {
                        buffer = this.read(buff, offset, 1);
                        this.length |= buffer[0] & 0xFF;
                        this.state = STATE.DATA;
                        this.remaining = this.length;
                        this.messageBuffer.clear();
                        Log.d((String)"BluetoothAPI", (String)("length read " + this.length));
                        if (this.length != 0) break;
                        this.state = STATE.PRE1;
                        break;
                    }
                    case DATA: {
                        buffer = this.read(buff, offset, this.remaining);
                        int bytes_read = buffer.length;
                        this.remaining -= bytes_read;
                        this.messageBuffer.addAll(Arrays.asList(BluetoothLengthStreamManager.toObject(buffer, bytes_read)));
                        if (this.remaining != 0) break;
                        Log.d((String)"BluetoothAPI", (String)"Invoking data received");
                        this.helper.invokeDataReceivedEvent(new CharArrayWrapper(this.messageBuffer.toArray()));
                        this.state = STATE.PRE1;
                    }
                }
                if (buffer == null) continue;
                offset += buffer.length;
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void sendData() {
        int length = this.data_out.length;
        byte l1 = (byte)((length & 0xFF00) >> 8);
        byte l2 = (byte)(length & 0xFF);
        int pre = 85;
        byte[] data = new byte[this.data_out.length + 4];
        data[0] = pre;
        data[1] = pre;
        data[2] = l1;
        data[3] = l2;
        System.arraycopy(this.data_out, 0, data, 4, this.data_out.length);
        this.transceiver.write(data);
    }

    private static enum STATE {
        PRE1,
        PRE2,
        LENGTH1,
        LENGTH2,
        DATA;

    }
}

