/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.dao;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;

@Configuration
@ConditionalOnClass(value={PersistenceExceptionTranslationPostProcessor.class})
public class PersistenceExceptionTranslationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.dao.exceptiontranslation", name={"enabled"}, matchIfMissing=true)
    public static PersistenceExceptionTranslationPostProcessor persistenceExceptionTranslationPostProcessor(Environment environment2) {
        PersistenceExceptionTranslationPostProcessor postProcessor = new PersistenceExceptionTranslationPostProcessor();
        boolean proxyTargetClass = environment2.getProperty("spring.aop.proxy-target-class", Boolean.class, Boolean.TRUE);
        postProcessor.setProxyTargetClass(proxyTargetClass);
        return postProcessor;
    }
}

