/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.batch.BasicBatchConfigurer;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.batch.JpaBatchConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@ConditionalOnClass(value={PlatformTransactionManager.class})
@ConditionalOnMissingBean(value={BatchConfigurer.class})
@Configuration
class BatchConfigurerConfiguration {
    BatchConfigurerConfiguration() {
    }

    @Configuration
    @ConditionalOnClass(name={"javax.persistence.EntityManagerFactory"})
    @ConditionalOnBean(name={"entityManagerFactory"})
    static class JpaBatchConfiguration {
        JpaBatchConfiguration() {
        }

        @Bean
        public JpaBatchConfigurer batchConfigurer(BatchProperties properties, DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers, EntityManagerFactory entityManagerFactory) {
            return new JpaBatchConfigurer(properties, dataSource, transactionManagerCustomizers.getIfAvailable(), entityManagerFactory);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(name={"entityManagerFactory"})
    static class JdbcBatchConfiguration {
        JdbcBatchConfiguration() {
        }

        @Bean
        public BasicBatchConfigurer batchConfigurer(BatchProperties properties, DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
            return new BasicBatchConfigurer(properties, dataSource, transactionManagerCustomizers.getIfAvailable());
        }
    }
}

