/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.remote;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.redisson.RedissonBucket;
import org.redisson.api.RFuture;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.RPromise;
import org.redisson.remote.BaseRemoteProxy;
import org.redisson.remote.BaseRemoteService;
import org.redisson.remote.RemoteServiceAck;
import org.redisson.remote.RemoteServiceAckTimeoutException;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RemoteServiceResponse;
import org.redisson.remote.RemoteServiceTimeoutException;
import org.redisson.remote.RequestId;
import org.redisson.remote.ResponseEntry;

public class SyncRemoteProxy
extends BaseRemoteProxy {
    public SyncRemoteProxy(CommandAsyncExecutor commandExecutor, String name, String responseQueueName, ConcurrentMap<String, ResponseEntry> responses, Codec codec, String executorId, BaseRemoteService remoteService) {
        super(commandExecutor, name, responseQueueName, responses, codec, executorId, remoteService);
    }

    public <T> T create(final Class<T> remoteInterface, RemoteInvocationOptions options) {
        final RemoteInvocationOptions optionsCopy = new RemoteInvocationOptions(options);
        final String toString = this.getClass().getSimpleName() + "-" + remoteInterface.getSimpleName() + "-proxy-" + this.remoteService.generateRequestId();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RPromise responseFuture;
                if (method.getName().equals("toString")) {
                    return toString;
                }
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return toString.hashCode();
                }
                if (!(optionsCopy.isResultExpected() || method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE))) {
                    throw new IllegalArgumentException("The noResult option only supports void return value");
                }
                RequestId requestId = SyncRemoteProxy.this.remoteService.generateRequestId();
                String requestQueueName = SyncRemoteProxy.this.getRequestQueueName(remoteInterface);
                RemoteServiceRequest request = new RemoteServiceRequest(SyncRemoteProxy.this.executorId, requestId.toString(), method.getName(), SyncRemoteProxy.this.remoteService.getMethodSignature(method), args, optionsCopy, System.currentTimeMillis());
                RPromise ackFuture = optionsCopy.isAckExpected() ? SyncRemoteProxy.this.pollResponse(optionsCopy.getAckTimeoutInMillis(), requestId, false) : null;
                if (optionsCopy.isResultExpected()) {
                    long timeout = SyncRemoteProxy.this.remoteService.getTimeout(optionsCopy.getExecutionTimeoutInMillis(), request);
                    responseFuture = SyncRemoteProxy.this.pollResponse(timeout, requestId, false);
                } else {
                    responseFuture = null;
                }
                RemotePromise<Object> addPromise = new RemotePromise<Object>(requestId);
                RFuture<Boolean> futureAdd = SyncRemoteProxy.this.remoteService.addAsync(requestQueueName, request, addPromise);
                futureAdd.await();
                if (!futureAdd.isSuccess()) {
                    if (responseFuture != null) {
                        responseFuture.cancel(false);
                    }
                    if (ackFuture != null) {
                        ackFuture.cancel(false);
                    }
                    throw futureAdd.cause();
                }
                if (!((Boolean)futureAdd.get()).booleanValue()) {
                    if (responseFuture != null) {
                        responseFuture.cancel(false);
                    }
                    if (ackFuture != null) {
                        ackFuture.cancel(false);
                    }
                    throw new RedisException("Task hasn't been added");
                }
                if (ackFuture != null) {
                    String ackName = SyncRemoteProxy.this.remoteService.getAckName(requestId);
                    ackFuture.await(optionsCopy.getAckTimeoutInMillis());
                    RemoteServiceAck ack = (RemoteServiceAck)ackFuture.getNow();
                    if (ack == null) {
                        RFuture<RemoteServiceAck> ackFutureAttempt = SyncRemoteProxy.this.tryPollAckAgainAsync(optionsCopy, ackName, requestId);
                        ackFutureAttempt.await(optionsCopy.getAckTimeoutInMillis());
                        ack = ackFutureAttempt.getNow();
                        if (ack == null) {
                            throw new RemoteServiceAckTimeoutException("No ACK response after " + optionsCopy.getAckTimeoutInMillis() + "ms for request: " + request);
                        }
                    }
                    new RedissonBucket(SyncRemoteProxy.this.commandExecutor, ackName).delete();
                }
                if (responseFuture != null) {
                    responseFuture.awaitUninterruptibly();
                    RemoteServiceResponse response = (RemoteServiceResponse)responseFuture.getNow();
                    if (response == null) {
                        throw new RemoteServiceTimeoutException("No response after " + optionsCopy.getExecutionTimeoutInMillis() + "ms for request: " + request);
                    }
                    if (response.getError() != null) {
                        throw response.getError();
                    }
                    if (method.getReturnType().equals(Optional.class)) {
                        if (response.getResult() == null) {
                            return Optional.empty();
                        }
                        return Optional.of(response.getResult());
                    }
                    return response.getResult();
                }
                return null;
            }
        };
        return (T)Proxy.newProxyInstance(remoteInterface.getClassLoader(), new Class[]{remoteInterface}, handler);
    }
}

