/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import java.util.concurrent.atomic.AtomicReference;
import org.redisson.client.RedisRedirectException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class BatchCommandData<T, R>
extends CommandData<T, R>
implements Comparable<BatchCommandData<T, R>> {
    private final int index;
    private final AtomicReference<RedisRedirectException> redirectError = new AtomicReference();

    public BatchCommandData(RedisCommand<T> command, Object[] params, int index) {
        this(new RedissonPromise(), StringCodec.INSTANCE, command, params, index);
    }

    public BatchCommandData(RPromise<R> promise, Codec codec, RedisCommand<T> command, Object[] params, int index) {
        super(promise, codec, command, params);
        this.index = index;
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        if (this.redirectError.get() != null) {
            return false;
        }
        if (cause instanceof RedisRedirectException) {
            return this.redirectError.compareAndSet(null, (RedisRedirectException)cause);
        }
        return super.tryFailure(cause);
    }

    @Override
    public boolean isSuccess() {
        return this.redirectError.get() == null && super.isSuccess();
    }

    @Override
    public Throwable cause() {
        if (this.redirectError.get() != null) {
            return this.redirectError.get();
        }
        return super.cause();
    }

    public void clearError() {
        this.redirectError.set(null);
    }

    @Override
    public int compareTo(BatchCommandData<T, R> o) {
        return this.index - o.index;
    }
}

