/*
 * Decompiled with CFR 0.152.
 */
package com.riven.redisson.message;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.riven.redisson.message.RedissonMessage;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class FastJsonCodec
extends StringCodec {
    public static final FastJsonCodec INSTANCE = new FastJsonCodec();
    private final Encoder encoder = object -> {
        String jsonStr = JSON.toJSONString(object);
        return super.getValueEncoder().encode(jsonStr);
    };
    private final Decoder<Object> decoder = (buf, state) -> {
        byte[] result = new byte[buf.readableBytes()];
        buf.readBytes(result);
        JSONObject jsonObject = (JSONObject)JSON.parse(result, new Feature[0]);
        Object payload = jsonObject.get("payload");
        String payloadStr = payload instanceof JSON ? ((JSON)payload).toJSONString() : JSON.toJSONString(payload);
        JSONObject headers = jsonObject.getJSONObject("headers");
        RedissonMessage redissonMessage = new RedissonMessage();
        redissonMessage.setPayload(payload == null ? new byte[]{} : payloadStr.getBytes(charset));
        redissonMessage.setHeaders(headers);
        return redissonMessage;
    };

    public FastJsonCodec() {
        this(StandardCharsets.UTF_8);
    }

    public FastJsonCodec(Charset charset) {
        super(charset);
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

