/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import java.time.Duration;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

public class JettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public JettyWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableJettyWebServerFactory factory) {
        ServerProperties properties = this.serverProperties;
        ServerProperties.Jetty jettyProperties = properties.getJetty();
        factory.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders(properties, this.environment));
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(jettyProperties::getAcceptors).whenNonNull().to(factory::setAcceptors);
        propertyMapper.from(jettyProperties::getSelectors).whenNonNull().to(factory::setSelectors);
        propertyMapper.from(properties::getMaxHttpHeaderSize).when(this::isPositive).to(maxHttpHeaderSize -> this.customizeMaxHttpHeaderSize(factory, (int)maxHttpHeaderSize));
        propertyMapper.from(jettyProperties::getMaxHttpPostSize).when(this::isPositive).to(maxHttpPostSize -> this.customizeMaxHttpPostSize(factory, (int)maxHttpPostSize));
        propertyMapper.from(properties::getConnectionTimeout).whenNonNull().to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        propertyMapper.from(jettyProperties::getAccesslog).when(ServerProperties.Jetty.Accesslog::isEnabled).to(accesslog -> this.customizeAccessLog(factory, (ServerProperties.Jetty.Accesslog)accesslog));
    }

    private boolean isPositive(Integer value) {
        return value > 0;
    }

    private boolean getOrDeduceUseForwardHeaders(ServerProperties serverProperties, Environment environment2) {
        if (serverProperties.isUseForwardHeaders() != null) {
            return serverProperties.isUseForwardHeaders();
        }
        CloudPlatform platform = CloudPlatform.getActive(environment2);
        return platform != null && platform.isUsingForwardHeaders();
    }

    private void customizeConnectionTimeout(ConfigurableJettyWebServerFactory factory, Duration connectionTimeout) {
        factory.addServerCustomizers(server -> {
            for (Connector connector : server.getConnectors()) {
                if (!(connector instanceof AbstractConnector)) continue;
                ((AbstractConnector)connector).setIdleTimeout(connectionTimeout.toMillis());
            }
        });
    }

    private void customizeMaxHttpHeaderSize(ConfigurableJettyWebServerFactory factory, final int maxHttpHeaderSize) {
        factory.addServerCustomizers(new JettyServerCustomizer(){

            @Override
            public void customize(Server server) {
                for (Connector connector : server.getConnectors()) {
                    for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                        if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory)) continue;
                        this.customize((HttpConfiguration.ConnectionFactory)connectionFactory);
                    }
                }
            }

            private void customize(HttpConfiguration.ConnectionFactory factory) {
                HttpConfiguration configuration = factory.getHttpConfiguration();
                configuration.setRequestHeaderSize(maxHttpHeaderSize);
                configuration.setResponseHeaderSize(maxHttpHeaderSize);
            }
        });
    }

    private void customizeMaxHttpPostSize(ConfigurableJettyWebServerFactory factory, final int maxHttpPostSize) {
        factory.addServerCustomizers(new JettyServerCustomizer(){

            @Override
            public void customize(Server server) {
                this.setHandlerMaxHttpPostSize(maxHttpPostSize, server.getHandlers());
            }

            private void setHandlerMaxHttpPostSize(int maxHttpPostSize2, Handler ... handlers) {
                for (Handler handler : handlers) {
                    if (handler instanceof ContextHandler) {
                        ((ContextHandler)handler).setMaxFormContentSize(maxHttpPostSize2);
                        continue;
                    }
                    if (handler instanceof HandlerWrapper) {
                        this.setHandlerMaxHttpPostSize(maxHttpPostSize2, ((HandlerWrapper)handler).getHandler());
                        continue;
                    }
                    if (!(handler instanceof HandlerCollection)) continue;
                    this.setHandlerMaxHttpPostSize(maxHttpPostSize2, ((HandlerCollection)handler).getHandlers());
                }
            }
        });
    }

    private void customizeAccessLog(ConfigurableJettyWebServerFactory factory, ServerProperties.Jetty.Accesslog properties) {
        factory.addServerCustomizers(server -> {
            NCSARequestLog log = new NCSARequestLog();
            if (properties.getFilename() != null) {
                log.setFilename(properties.getFilename());
            }
            if (properties.getFileDateFormat() != null) {
                log.setFilenameDateFormat(properties.getFileDateFormat());
            }
            log.setRetainDays(properties.getRetentionPeriod());
            log.setAppend(properties.isAppend());
            log.setExtended(properties.isExtendedFormat());
            if (properties.getDateFormat() != null) {
                log.setLogDateFormat(properties.getDateFormat());
            }
            if (properties.getLocale() != null) {
                log.setLogLocale(properties.getLocale());
            }
            if (properties.getTimeZone() != null) {
                log.setLogTimeZone(properties.getTimeZone().getID());
            }
            log.setLogCookies(properties.isLogCookies());
            log.setLogServer(properties.isLogServer());
            log.setLogLatency(properties.isLogLatency());
            server.setRequestLog((RequestLog)log);
        });
    }
}

