/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import java.util.ArrayList;
import java.util.Arrays;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.spring.support.RedissonNamespaceDecorator;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public class RemoteInvocationOptionDecorator
implements RedissonNamespaceDecorator {
    @Override
    public void decorate(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, RedissonNamespaceParserSupport helper) {
        if (helper.hasElement(element, "remote-invocation-options")) {
            ArrayList<String> args;
            Element options = helper.getSingleElement(element, "remote-invocation-options");
            String optionBeanId = this.invokeOptions(options, parserContext, helper);
            if (helper.hasElement(element, "remote-no-ack")) {
                helper.invoker(optionBeanId, "noAck", null, parserContext);
            }
            if (helper.hasElement(element, "remote-ack")) {
                Element remoteAck = helper.getSingleElement(element, "remote-ack");
                Assert.state(helper.hasAttribute(remoteAck, "within"), "Missing \"within\" attribute in \"remote-ack\" element.");
                args = new ArrayList<String>(2);
                args.add(helper.getAttribute(remoteAck, "within"));
                if (helper.hasAttribute(remoteAck, "time-unit")) {
                    args.add(helper.getAttribute(remoteAck, "time-unit"));
                }
                helper.invoker(optionBeanId, "expectAckWithin", args.toArray(), parserContext);
            }
            if (helper.hasElement(element, "remote-no-result")) {
                helper.invoker(optionBeanId, "noResult", null, parserContext);
            }
            if (helper.hasElement(element, "remote-result")) {
                Element remoteResult = helper.getSingleElement(element, "remote-result");
                Assert.state(helper.hasAttribute(remoteResult, "within"), "Missing \"within\" attribute in \"remote-result\" element.");
                args = new ArrayList(2);
                args.add(helper.getAttribute(remoteResult, "within"));
                if (helper.hasAttribute(remoteResult, "time-unit")) {
                    args.add(helper.getAttribute(remoteResult, "time-unit"));
                }
                helper.invoker(optionBeanId, "expectResultWithin", args.toArray(), parserContext);
            }
            MutablePropertyValues properties = builder.getRawBeanDefinition().getPropertyValues();
            PropertyValue propertyValue = properties.getPropertyValue("arguments");
            ManagedList<Object> args2 = new ManagedList<Object>();
            args2.addAll(Arrays.asList((Object[])propertyValue.getValue()));
            args2.add(new RuntimeBeanReference(optionBeanId));
            properties.removePropertyValue("arguments");
            properties.addPropertyValue("arguments", args2);
        }
    }

    private String invokeOptions(Element element, ParserContext parserContext, RedissonNamespaceParserSupport helper) {
        BeanComponentDefinition defaultOption = helper.factoryInvoker(element, RemoteInvocationOptions.class, "defaults", null, parserContext);
        return defaultOption.getName();
    }
}

