/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.tcp.reactor;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelPipeline;
import org.springframework.messaging.Message;
import org.springframework.messaging.tcp.TcpConnection;
import org.springframework.messaging.tcp.reactor.MonoToListenableFutureAdapter;
import org.springframework.messaging.tcp.reactor.ReactorNettyCodec;
import org.springframework.util.concurrent.ListenableFuture;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;

public class ReactorNettyTcpConnection<P>
implements TcpConnection<P> {
    private final NettyInbound inbound;
    private final NettyOutbound outbound;
    private final ReactorNettyCodec<P> codec;
    private final DirectProcessor<Void> closeProcessor;

    public ReactorNettyTcpConnection(NettyInbound inbound, NettyOutbound outbound, ReactorNettyCodec<P> codec, DirectProcessor<Void> closeProcessor) {
        this.inbound = inbound;
        this.outbound = outbound;
        this.codec = codec;
        this.closeProcessor = closeProcessor;
    }

    @Override
    public ListenableFuture<Void> send(Message<P> message) {
        ByteBuf byteBuf = this.outbound.alloc().buffer();
        this.codec.encode(message, byteBuf);
        Mono sendCompletion = this.outbound.send(Mono.just(byteBuf)).then();
        return new MonoToListenableFutureAdapter<Void>(sendCompletion);
    }

    @Override
    public void onReadInactivity(Runnable runnable, long inactivityDuration) {
        String name;
        ChannelPipeline pipeline = this.inbound.context().channel().pipeline();
        if (pipeline.context(name = "reactor.left.onChannelReadIdle") != null) {
            pipeline.remove(name);
        }
        this.inbound.onReadIdle(inactivityDuration, runnable);
    }

    @Override
    public void onWriteInactivity(Runnable runnable, long inactivityDuration) {
        this.outbound.onWriteIdle(inactivityDuration, runnable);
    }

    @Override
    public void close() {
        this.closeProcessor.onComplete();
    }
}

