/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase;

import liquibase.logging.LogLevel;
import liquibase.logging.core.AbstractLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsLoggingLiquibaseLogger
extends AbstractLogger {
    public static final int PRIORITY = 10;
    private Log logger;

    public void setName(String name) {
        this.logger = this.createLogger(name);
    }

    protected Log createLogger(String name) {
        return LogFactory.getLog(name);
    }

    public void setLogLevel(String logLevel, String logFile) {
        super.setLogLevel(logLevel);
    }

    public void severe(String message) {
        if (this.isEnabled(LogLevel.SEVERE)) {
            this.logger.error(this.buildMessage(message));
        }
    }

    public void severe(String message, Throwable e) {
        if (this.isEnabled(LogLevel.SEVERE)) {
            this.logger.error(this.buildMessage(message), e);
        }
    }

    public void warning(String message) {
        if (this.isEnabled(LogLevel.WARNING)) {
            this.logger.warn(this.buildMessage(message));
        }
    }

    public void warning(String message, Throwable e) {
        if (this.isEnabled(LogLevel.WARNING)) {
            this.logger.warn(this.buildMessage(message), e);
        }
    }

    public void info(String message) {
        if (this.isEnabled(LogLevel.INFO)) {
            this.logger.info(this.buildMessage(message));
        }
    }

    public void info(String message, Throwable e) {
        if (this.isEnabled(LogLevel.INFO)) {
            this.logger.info(this.buildMessage(message), e);
        }
    }

    public void debug(String message) {
        if (this.isEnabled(LogLevel.DEBUG)) {
            this.logger.debug(this.buildMessage(message));
        }
    }

    public void debug(String message, Throwable e) {
        if (this.isEnabled(LogLevel.DEBUG)) {
            this.logger.debug(this.buildMessage(message), e);
        }
    }

    public int getPriority() {
        return 10;
    }

    private boolean isEnabled(LogLevel level) {
        if (this.logger != null) {
            switch (level) {
                case DEBUG: {
                    return this.logger.isDebugEnabled();
                }
                case INFO: {
                    return this.logger.isInfoEnabled();
                }
                case WARNING: {
                    return this.logger.isWarnEnabled();
                }
                case SEVERE: {
                    return this.logger.isErrorEnabled();
                }
            }
        }
        return false;
    }
}

