/*
 * Decompiled with CFR 0.152.
 */
package com.riven.redisson.config;

import com.riven.redisson.config.RedissonProperties;
import com.riven.redisson.config.RedissonQueueBeanPostProcessor;
import com.riven.redisson.config.RedissonQueueRegistry;
import com.riven.redisson.config.RedissonTemplate;
import com.riven.redisson.consts.ServerType;
import java.util.Objects;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={RedissonClient.class, Redisson.class})
@EnableConfigurationProperties(value={RedissonProperties.class})
public class RedissonAutoConfiguration {
    @Scope(value="singleton")
    @Bean(name={"com.riven.redisson.internalRedissonQueueBeanProcessor"})
    public RedissonQueueBeanPostProcessor redissonQueueBeanPostProcessor() {
        return new RedissonQueueBeanPostProcessor();
    }

    @Scope(value="singleton")
    @Bean(name={"com.riven.redisson.internalRedissonQueueRegistry"})
    public RedissonQueueRegistry redissonQueueRegistry() {
        return new RedissonQueueRegistry();
    }

    @Scope(value="singleton")
    @Bean
    @ConditionalOnMissingBean
    public RedissonTemplate redissonTemplate() {
        return new RedissonTemplate();
    }

    @Scope(value="singleton")
    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean
    public RedissonClient redissonClient(RedissonProperties properties) {
        ServerType serverType = properties.getServerType();
        String serverAddress = properties.getServerAddress();
        Assert.hasText(serverAddress, "redis cluster nodes config error");
        String password = properties.getPassword();
        Config config = new Config();
        config.setThreads(properties.getThreads());
        config.setNettyThreads(properties.getNettyThreads());
        config.setLockWatchdogTimeout(properties.getLockWatchdogTimeoutMillis());
        if (serverType == ServerType.SINGLE) {
            SingleServerConfig singleServerConfig = config.useSingleServer();
            singleServerConfig.setAddress(this.checkAndFixAddress(serverAddress));
            if (StringUtils.hasText(password)) {
                singleServerConfig.setPassword(password);
            }
            singleServerConfig.setDatabase(properties.getDatabase());
            singleServerConfig.setConnectTimeout(properties.getConnectTimeoutMillis());
            singleServerConfig.setTimeout(properties.getSocketTimeoutMillis());
            singleServerConfig.setKeepAlive(properties.isKeepAlive());
            singleServerConfig.setRetryAttempts(properties.getRetryAttempts());
            singleServerConfig.setRetryInterval(properties.getRetryIntervalMillis());
            singleServerConfig.setConnectionPoolSize(properties.getMaxPoolSize());
            singleServerConfig.setConnectionMinimumIdleSize(properties.getMinIdleSize());
            singleServerConfig.setIdleConnectionTimeout(properties.getMaxIdleMillis());
            return Redisson.create(config);
        }
        if (serverType == ServerType.CLUSTER) {
            String[] nodes;
            ClusterServersConfig clusterServersConfig = config.useClusterServers();
            for (String node : nodes = serverAddress.split("[,;]")) {
                clusterServersConfig.addNodeAddress(this.checkAndFixAddress(node));
            }
            if (StringUtils.hasText(password)) {
                clusterServersConfig.setPassword(password);
            }
            clusterServersConfig.setConnectTimeout(properties.getConnectTimeoutMillis());
            clusterServersConfig.setTimeout(properties.getSocketTimeoutMillis());
            clusterServersConfig.setKeepAlive(properties.isKeepAlive());
            clusterServersConfig.setRetryAttempts(properties.getRetryAttempts());
            clusterServersConfig.setRetryInterval(properties.getRetryIntervalMillis());
            int masterMaxPoolSize = Objects.nonNull(properties.getMaster()) ? properties.getMaster().getMaxPoolSize() : properties.getMaxPoolSize();
            int masterMinIdleSize = Objects.nonNull(properties.getMaster()) ? properties.getMaster().getMinIdleSize() : properties.getMinIdleSize();
            int slaveMaxPoolSize = Objects.nonNull(properties.getSlave()) ? properties.getSlave().getMaxPoolSize() : properties.getMaxPoolSize();
            int slaveMinIdleSize = Objects.nonNull(properties.getSlave()) ? properties.getSlave().getMinIdleSize() : properties.getMinIdleSize();
            clusterServersConfig.setMasterConnectionPoolSize(masterMaxPoolSize);
            clusterServersConfig.setMasterConnectionMinimumIdleSize(masterMinIdleSize);
            clusterServersConfig.setSlaveConnectionPoolSize(slaveMaxPoolSize);
            clusterServersConfig.setSlaveConnectionMinimumIdleSize(slaveMinIdleSize);
            clusterServersConfig.setIdleConnectionTimeout(properties.getMaxIdleMillis());
            return Redisson.create(config);
        }
        throw new BeanCreationException("redis server type is illegal");
    }

    private String checkAndFixAddress(String address) {
        String protocol = "redis://";
        String sslProtocol = "rediss://";
        if (address.startsWith("redis://") || address.startsWith("rediss://")) {
            return address;
        }
        return "redis://" + address;
    }
}

