/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.servlet;

import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class ApplicationContextRequestMatcher<C>
implements RequestMatcher {
    private final Class<? extends C> contextClass;
    private volatile Supplier<C> context;
    private final Object contextLock = new Object();

    public ApplicationContextRequestMatcher(Class<? extends C> contextClass) {
        Assert.notNull(contextClass, "Context class must not be null");
        this.contextClass = contextClass;
    }

    public final boolean matches(HttpServletRequest request) {
        return this.matches(request, this.getContext(request));
    }

    protected abstract boolean matches(HttpServletRequest var1, Supplier<C> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Supplier<C> getContext(HttpServletRequest request) {
        if (this.context == null) {
            Object object = this.contextLock;
            synchronized (object) {
                if (this.context == null) {
                    Supplier<C> createdContext = this.createContext(request);
                    this.initialized(createdContext);
                    this.context = createdContext;
                }
            }
        }
        return this.context;
    }

    protected void initialized(Supplier<C> context) {
    }

    private Supplier<C> createContext(HttpServletRequest request) {
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext());
        if (this.contextClass.isInstance(context)) {
            return () -> context;
        }
        return () -> context.getBean(this.contextClass);
    }
}

