/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.broker.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.broker.SimpleBrokerMessageHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.config.TaskExecutorRegistration;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.messaging.simp.user.DefaultUserDestinationResolver;
import org.springframework.messaging.simp.user.MultiServerUserRegistry;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.messaging.simp.user.UserDestinationMessageHandler;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserRegistryMessageHandler;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.messaging.support.ImmutableMessageChannelInterceptor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.PathMatcher;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class AbstractMessageBrokerConfiguration
implements ApplicationContextAware {
    private static final String MVC_VALIDATOR_NAME = "mvcValidator";
    private static final boolean jackson2Present = ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", AbstractMessageBrokerConfiguration.class.getClassLoader());
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private ChannelRegistration clientInboundChannelRegistration;
    @Nullable
    private ChannelRegistration clientOutboundChannelRegistration;
    @Nullable
    private MessageBrokerRegistry brokerRegistry;

    protected AbstractMessageBrokerConfiguration() {
    }

    @Override
    public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Bean
    public AbstractSubscribableChannel clientInboundChannel() {
        ExecutorSubscribableChannel channel = new ExecutorSubscribableChannel(this.clientInboundChannelExecutor());
        ChannelRegistration reg = this.getClientInboundChannelRegistration();
        if (reg.hasInterceptors()) {
            channel.setInterceptors(reg.getInterceptors());
        }
        return channel;
    }

    @Bean
    public ThreadPoolTaskExecutor clientInboundChannelExecutor() {
        TaskExecutorRegistration reg = this.getClientInboundChannelRegistration().taskExecutor();
        ThreadPoolTaskExecutor executor = reg.getTaskExecutor();
        executor.setThreadNamePrefix("clientInboundChannel-");
        return executor;
    }

    protected final ChannelRegistration getClientInboundChannelRegistration() {
        if (this.clientInboundChannelRegistration == null) {
            ChannelRegistration registration = new ChannelRegistration();
            this.configureClientInboundChannel(registration);
            registration.interceptors(new ImmutableMessageChannelInterceptor());
            this.clientInboundChannelRegistration = registration;
        }
        return this.clientInboundChannelRegistration;
    }

    protected void configureClientInboundChannel(ChannelRegistration registration) {
    }

    @Bean
    public AbstractSubscribableChannel clientOutboundChannel() {
        ExecutorSubscribableChannel channel = new ExecutorSubscribableChannel(this.clientOutboundChannelExecutor());
        ChannelRegistration reg = this.getClientOutboundChannelRegistration();
        if (reg.hasInterceptors()) {
            channel.setInterceptors(reg.getInterceptors());
        }
        return channel;
    }

    @Bean
    public ThreadPoolTaskExecutor clientOutboundChannelExecutor() {
        TaskExecutorRegistration reg = this.getClientOutboundChannelRegistration().taskExecutor();
        ThreadPoolTaskExecutor executor = reg.getTaskExecutor();
        executor.setThreadNamePrefix("clientOutboundChannel-");
        return executor;
    }

    protected final ChannelRegistration getClientOutboundChannelRegistration() {
        if (this.clientOutboundChannelRegistration == null) {
            ChannelRegistration registration = new ChannelRegistration();
            this.configureClientOutboundChannel(registration);
            registration.interceptors(new ImmutableMessageChannelInterceptor());
            this.clientOutboundChannelRegistration = registration;
        }
        return this.clientOutboundChannelRegistration;
    }

    protected void configureClientOutboundChannel(ChannelRegistration registration) {
    }

    @Bean
    public AbstractSubscribableChannel brokerChannel() {
        ChannelRegistration reg = this.getBrokerRegistry().getBrokerChannelRegistration();
        ExecutorSubscribableChannel channel = reg.hasTaskExecutor() ? new ExecutorSubscribableChannel(this.brokerChannelExecutor()) : new ExecutorSubscribableChannel();
        reg.interceptors(new ImmutableMessageChannelInterceptor());
        channel.setInterceptors(reg.getInterceptors());
        return channel;
    }

    @Bean
    public ThreadPoolTaskExecutor brokerChannelExecutor() {
        ThreadPoolTaskExecutor executor;
        ChannelRegistration reg = this.getBrokerRegistry().getBrokerChannelRegistration();
        if (reg.hasTaskExecutor()) {
            executor = reg.taskExecutor().getTaskExecutor();
        } else {
            executor = new ThreadPoolTaskExecutor();
            executor.setCorePoolSize(0);
            executor.setMaxPoolSize(1);
            executor.setQueueCapacity(0);
        }
        executor.setThreadNamePrefix("brokerChannel-");
        return executor;
    }

    protected final MessageBrokerRegistry getBrokerRegistry() {
        if (this.brokerRegistry == null) {
            MessageBrokerRegistry registry = new MessageBrokerRegistry(this.clientInboundChannel(), this.clientOutboundChannel());
            this.configureMessageBroker(registry);
            this.brokerRegistry = registry;
        }
        return this.brokerRegistry;
    }

    protected void configureMessageBroker(MessageBrokerRegistry registry) {
    }

    @Nullable
    public final PathMatcher getPathMatcher() {
        return this.getBrokerRegistry().getPathMatcher();
    }

    @Bean
    public SimpAnnotationMethodMessageHandler simpAnnotationMethodMessageHandler() {
        SimpAnnotationMethodMessageHandler handler = this.createAnnotationMethodMessageHandler();
        handler.setDestinationPrefixes(this.getBrokerRegistry().getApplicationDestinationPrefixes());
        handler.setMessageConverter(this.brokerMessageConverter());
        handler.setValidator(this.simpValidator());
        ArrayList<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
        this.addArgumentResolvers(argumentResolvers);
        handler.setCustomArgumentResolvers(argumentResolvers);
        ArrayList<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();
        this.addReturnValueHandlers(returnValueHandlers);
        handler.setCustomReturnValueHandlers(returnValueHandlers);
        PathMatcher pathMatcher = this.getBrokerRegistry().getPathMatcher();
        if (pathMatcher != null) {
            handler.setPathMatcher(pathMatcher);
        }
        return handler;
    }

    protected SimpAnnotationMethodMessageHandler createAnnotationMethodMessageHandler() {
        return new SimpAnnotationMethodMessageHandler(this.clientInboundChannel(), this.clientOutboundChannel(), this.brokerMessagingTemplate());
    }

    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
    }

    protected void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
    }

    @Bean
    public AbstractBrokerMessageHandler simpleBrokerMessageHandler() {
        SimpleBrokerMessageHandler handler = this.getBrokerRegistry().getSimpleBroker(this.brokerChannel());
        if (handler == null) {
            return new NoOpBrokerMessageHandler();
        }
        this.updateUserDestinationResolver(handler);
        return handler;
    }

    private void updateUserDestinationResolver(AbstractBrokerMessageHandler handler) {
        Collection<String> prefixes = handler.getDestinationPrefixes();
        if (!prefixes.isEmpty() && !prefixes.iterator().next().startsWith("/")) {
            ((DefaultUserDestinationResolver)this.userDestinationResolver()).setRemoveLeadingSlash(true);
        }
    }

    @Bean
    public AbstractBrokerMessageHandler stompBrokerRelayMessageHandler() {
        StompBrokerRelayMessageHandler handler = this.getBrokerRegistry().getStompBrokerRelay(this.brokerChannel());
        if (handler == null) {
            return new NoOpBrokerMessageHandler();
        }
        HashMap<String, MessageHandler> subscriptions = new HashMap<String, MessageHandler>(4);
        String destination = this.getBrokerRegistry().getUserDestinationBroadcast();
        if (destination != null) {
            subscriptions.put(destination, this.userDestinationMessageHandler());
        }
        if ((destination = this.getBrokerRegistry().getUserRegistryBroadcast()) != null) {
            subscriptions.put(destination, this.userRegistryMessageHandler());
        }
        handler.setSystemSubscriptions(subscriptions);
        this.updateUserDestinationResolver(handler);
        return handler;
    }

    @Bean
    public UserDestinationMessageHandler userDestinationMessageHandler() {
        UserDestinationMessageHandler handler = new UserDestinationMessageHandler(this.clientInboundChannel(), this.brokerChannel(), this.userDestinationResolver());
        String destination = this.getBrokerRegistry().getUserDestinationBroadcast();
        if (destination != null) {
            handler.setBroadcastDestination(destination);
        }
        return handler;
    }

    @Bean
    public MessageHandler userRegistryMessageHandler() {
        if (this.getBrokerRegistry().getUserRegistryBroadcast() == null) {
            return new NoOpMessageHandler();
        }
        SimpUserRegistry userRegistry = this.userRegistry();
        Assert.isInstanceOf(MultiServerUserRegistry.class, (Object)userRegistry, "MultiServerUserRegistry required");
        return new UserRegistryMessageHandler((MultiServerUserRegistry)userRegistry, this.brokerMessagingTemplate(), this.getBrokerRegistry().getUserRegistryBroadcast(), this.messageBrokerTaskScheduler());
    }

    @Bean(name={"messageBrokerTaskScheduler", "messageBrokerSockJsTaskScheduler"})
    public ThreadPoolTaskScheduler messageBrokerTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("MessageBroker-");
        scheduler.setPoolSize(Runtime.getRuntime().availableProcessors());
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    @Bean
    public SimpMessagingTemplate brokerMessagingTemplate() {
        SimpMessagingTemplate template = new SimpMessagingTemplate(this.brokerChannel());
        String prefix = this.getBrokerRegistry().getUserDestinationPrefix();
        if (prefix != null) {
            template.setUserDestinationPrefix(prefix);
        }
        template.setMessageConverter(this.brokerMessageConverter());
        return template;
    }

    @Bean
    public CompositeMessageConverter brokerMessageConverter() {
        ArrayList<MessageConverter> converters = new ArrayList<MessageConverter>();
        boolean registerDefaults = this.configureMessageConverters(converters);
        if (registerDefaults) {
            converters.add(new StringMessageConverter());
            converters.add(new ByteArrayMessageConverter());
            if (jackson2Present) {
                converters.add(this.createJacksonConverter());
            }
        }
        return new CompositeMessageConverter(converters);
    }

    protected MappingJackson2MessageConverter createJacksonConverter() {
        DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
        resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setContentTypeResolver(resolver);
        return converter;
    }

    protected boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        return true;
    }

    @Bean
    public UserDestinationResolver userDestinationResolver() {
        DefaultUserDestinationResolver resolver = new DefaultUserDestinationResolver(this.userRegistry());
        String prefix = this.getBrokerRegistry().getUserDestinationPrefix();
        if (prefix != null) {
            resolver.setUserDestinationPrefix(prefix);
        }
        return resolver;
    }

    @Bean
    public SimpUserRegistry userRegistry() {
        return this.getBrokerRegistry().getUserRegistryBroadcast() != null ? new MultiServerUserRegistry(this.createLocalUserRegistry()) : this.createLocalUserRegistry();
    }

    protected abstract SimpUserRegistry createLocalUserRegistry();

    protected Validator simpValidator() {
        Validator validator = this.getValidator();
        if (validator == null) {
            if (this.applicationContext != null && this.applicationContext.containsBean(MVC_VALIDATOR_NAME)) {
                validator = this.applicationContext.getBean(MVC_VALIDATOR_NAME, Validator.class);
            } else if (ClassUtils.isPresent("javax.validation.Validator", this.getClass().getClassLoader())) {
                Class<?> clazz;
                try {
                    String className = "org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean";
                    clazz = ClassUtils.forName(className, AbstractMessageBrokerConfiguration.class.getClassLoader());
                }
                catch (Throwable ex) {
                    throw new BeanInitializationException("Could not find default validator class", ex);
                }
                validator = (Validator)BeanUtils.instantiateClass(clazz);
            } else {
                validator = new Validator(){

                    @Override
                    public boolean supports(Class<?> clazz) {
                        return false;
                    }

                    @Override
                    public void validate(@Nullable Object target, Errors errors) {
                    }
                };
            }
        }
        return validator;
    }

    @Nullable
    public Validator getValidator() {
        return null;
    }

    private class NoOpBrokerMessageHandler
    extends AbstractBrokerMessageHandler {
        public NoOpBrokerMessageHandler() {
            super(AbstractMessageBrokerConfiguration.this.clientInboundChannel(), AbstractMessageBrokerConfiguration.this.clientOutboundChannel(), AbstractMessageBrokerConfiguration.this.brokerChannel());
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void handleMessage(Message<?> message) {
        }

        @Override
        protected void handleMessageInternal(Message<?> message) {
        }
    }

    private static class NoOpMessageHandler
    implements MessageHandler {
        private NoOpMessageHandler() {
        }

        @Override
        public void handleMessage(Message<?> message) {
        }
    }
}

