/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import io.undertow.UndertowOptions;
import java.time.Duration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

public class UndertowWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableUndertowWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public UndertowWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableUndertowWebServerFactory factory) {
        ServerProperties properties = this.serverProperties;
        ServerProperties.Undertow undertowProperties = properties.getUndertow();
        ServerProperties.Undertow.Accesslog accesslogProperties = undertowProperties.getAccesslog();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from(undertowProperties::getBufferSize).to(factory::setBufferSize);
        propertyMapper.from(undertowProperties::getIoThreads).to(factory::setIoThreads);
        propertyMapper.from(undertowProperties::getWorkerThreads).to(factory::setWorkerThreads);
        propertyMapper.from(undertowProperties::getDirectBuffers).to(factory::setUseDirectBuffers);
        propertyMapper.from(accesslogProperties::isEnabled).to(factory::setAccessLogEnabled);
        propertyMapper.from(accesslogProperties::getDir).to(factory::setAccessLogDirectory);
        propertyMapper.from(accesslogProperties::getPattern).to(factory::setAccessLogPattern);
        propertyMapper.from(accesslogProperties::getPrefix).to(factory::setAccessLogPrefix);
        propertyMapper.from(accesslogProperties::getSuffix).to(factory::setAccessLogSuffix);
        propertyMapper.from(accesslogProperties::isRotate).to(factory::setAccessLogRotate);
        propertyMapper.from(() -> this.getOrDeduceUseForwardHeaders()).to(factory::setUseForwardHeaders);
        propertyMapper.from(properties::getMaxHttpHeaderSize).when(this::isPositive).to(maxHttpHeaderSize -> this.customizeMaxHttpHeaderSize(factory, (int)maxHttpHeaderSize));
        propertyMapper.from(undertowProperties::getMaxHttpPostSize).when(this::isPositive).to(maxHttpPostSize -> this.customizeMaxHttpPostSize(factory, (long)maxHttpPostSize));
        propertyMapper.from(properties::getConnectionTimeout).to(connectionTimeout -> this.customizeConnectionTimeout(factory, (Duration)connectionTimeout));
        factory.addDeploymentInfoCustomizers(deploymentInfo -> deploymentInfo.setEagerFilterInit(undertowProperties.isEagerFilterInit()));
    }

    private boolean isPositive(Number value) {
        return value.longValue() > 0L;
    }

    private void customizeConnectionTimeout(ConfigurableUndertowWebServerFactory factory, Duration connectionTimeout) {
        factory.addBuilderCustomizers(builder -> builder.setSocketOption(UndertowOptions.NO_REQUEST_TIMEOUT, (Object)((int)connectionTimeout.toMillis())));
    }

    private void customizeMaxHttpHeaderSize(ConfigurableUndertowWebServerFactory factory, int maxHttpHeaderSize) {
        factory.addBuilderCustomizers(builder -> builder.setServerOption(UndertowOptions.MAX_HEADER_SIZE, (Object)maxHttpHeaderSize));
    }

    private void customizeMaxHttpPostSize(ConfigurableUndertowWebServerFactory factory, long maxHttpPostSize) {
        factory.addBuilderCustomizers(builder -> builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)maxHttpPostSize));
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.isUseForwardHeaders() != null) {
            return this.serverProperties.isUseForwardHeaders();
        }
        CloudPlatform platform = CloudPlatform.getActive(this.environment);
        return platform != null && platform.isUsingForwardHeaders();
    }
}

