/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jooq.SQLDialect;
import org.jooq.tools.jdbc.JDBCUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

final class SqlDialectLookup {
    private static final Log logger = LogFactory.getLog(SqlDialectLookup.class);

    private SqlDialectLookup() {
    }

    public static SQLDialect getDialect(DataSource dataSource) {
        if (dataSource == null) {
            return SQLDialect.DEFAULT;
        }
        try {
            String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getURL");
            SQLDialect sqlDialect = JDBCUtils.dialect((String)url);
            if (sqlDialect != null) {
                return sqlDialect;
            }
        }
        catch (MetaDataAccessException ex) {
            logger.warn("Unable to determine jdbc url from datasource", ex);
        }
        return SQLDialect.DEFAULT;
    }
}

