/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.reactive.context;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.web.reactive.context.ConfigurableReactiveWebApplicationContext;
import org.springframework.boot.web.reactive.context.FilteredReactiveWebContextResource;
import org.springframework.boot.web.reactive.context.StandardReactiveWebEnvironment;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AnnotationConfigReactiveWebApplicationContext
extends AbstractRefreshableConfigApplicationContext
implements ConfigurableReactiveWebApplicationContext,
AnnotationConfigRegistry {
    private BeanNameGenerator beanNameGenerator;
    private ScopeMetadataResolver scopeMetadataResolver;
    private final Set<Class<?>> annotatedClasses = new LinkedHashSet();
    private final Set<String> basePackages = new LinkedHashSet<String>();

    @Override
    protected ConfigurableEnvironment createEnvironment() {
        return new StandardReactiveWebEnvironment();
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    protected BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver;
    }

    protected ScopeMetadataResolver getScopeMetadataResolver() {
        return this.scopeMetadataResolver;
    }

    @Override
    public void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty((Object[])annotatedClasses, "At least one annotated class must be specified");
        this.annotatedClasses.addAll(Arrays.asList(annotatedClasses));
    }

    @Override
    public void scan(String ... basePackages) {
        Assert.notEmpty((Object[])basePackages, "At least one base package must be specified");
        this.basePackages.addAll(Arrays.asList(basePackages));
    }

    @Override
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        AnnotatedBeanDefinitionReader reader = this.getAnnotatedBeanDefinitionReader(beanFactory);
        ClassPathBeanDefinitionScanner scanner = this.getClassPathBeanDefinitionScanner(beanFactory);
        this.applyBeanNameGenerator(beanFactory, reader, scanner);
        this.applyScopeMetadataResolver(reader, scanner);
        this.loadBeanDefinitions(reader, scanner);
    }

    private void applyBeanNameGenerator(DefaultListableBeanFactory beanFactory, AnnotatedBeanDefinitionReader reader, ClassPathBeanDefinitionScanner scanner) {
        BeanNameGenerator beanNameGenerator = this.getBeanNameGenerator();
        if (beanNameGenerator != null) {
            reader.setBeanNameGenerator(beanNameGenerator);
            scanner.setBeanNameGenerator(beanNameGenerator);
            beanFactory.registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", beanNameGenerator);
        }
    }

    private void applyScopeMetadataResolver(AnnotatedBeanDefinitionReader reader, ClassPathBeanDefinitionScanner scanner) {
        ScopeMetadataResolver scopeMetadataResolver = this.getScopeMetadataResolver();
        if (scopeMetadataResolver != null) {
            reader.setScopeMetadataResolver(scopeMetadataResolver);
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
    }

    private void loadBeanDefinitions(AnnotatedBeanDefinitionReader reader, ClassPathBeanDefinitionScanner scanner) throws LinkageError {
        String[] configLocations;
        if (!this.annotatedClasses.isEmpty()) {
            this.registerAnnotatedClasses(reader);
        }
        if (!this.basePackages.isEmpty()) {
            this.scanBasePackages(scanner);
        }
        if ((configLocations = this.getConfigLocations()) != null) {
            this.registerConfigLocations(reader, scanner, configLocations);
        }
    }

    private void registerAnnotatedClasses(AnnotatedBeanDefinitionReader reader) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Registering annotated classes: [" + StringUtils.collectionToCommaDelimitedString(this.annotatedClasses) + "]");
        }
        reader.register(ClassUtils.toClassArray(this.annotatedClasses));
    }

    private void scanBasePackages(ClassPathBeanDefinitionScanner scanner) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Scanning base packages: [" + StringUtils.collectionToCommaDelimitedString(this.basePackages) + "]");
        }
        scanner.scan(StringUtils.toStringArray(this.basePackages));
    }

    private void registerConfigLocations(AnnotatedBeanDefinitionReader reader, ClassPathBeanDefinitionScanner scanner, String[] configLocations) throws LinkageError {
        for (String configLocation : configLocations) {
            try {
                this.register(reader, configLocation);
            }
            catch (ClassNotFoundException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Could not load class for config location [" + configLocation + "] - trying package scan. " + ex);
                }
                int count = scanner.scan(configLocation);
                if (!this.logger.isInfoEnabled()) continue;
                this.logScanResult(configLocation, count);
            }
        }
    }

    private void register(AnnotatedBeanDefinitionReader reader, String configLocation) throws ClassNotFoundException, LinkageError {
        Class<?> clazz = ClassUtils.forName(configLocation, this.getClassLoader());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Successfully resolved class for [" + configLocation + "]");
        }
        reader.register(clazz);
    }

    private void logScanResult(String configLocation, int count) {
        if (count == 0) {
            this.logger.info("No annotated classes found for specified class/package [" + configLocation + "]");
        } else {
            this.logger.info("Found " + count + " annotated classes in package [" + configLocation + "]");
        }
    }

    protected AnnotatedBeanDefinitionReader getAnnotatedBeanDefinitionReader(DefaultListableBeanFactory beanFactory) {
        return new AnnotatedBeanDefinitionReader(beanFactory, this.getEnvironment());
    }

    protected ClassPathBeanDefinitionScanner getClassPathBeanDefinitionScanner(DefaultListableBeanFactory beanFactory) {
        return new ClassPathBeanDefinitionScanner(beanFactory, true, this.getEnvironment());
    }

    @Override
    protected Resource getResourceByPath(String path) {
        return new FilteredReactiveWebContextResource(path);
    }
}

