/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.reflect.Modifier;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.core.ResolvableType;

public class JsonComponentModule
extends SimpleModule
implements BeanFactoryAware {
    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @PostConstruct
    public void registerJsonComponents() {
        BeanFactory beanFactory = this.beanFactory;
        while (beanFactory != null) {
            if (beanFactory instanceof ListableBeanFactory) {
                this.addJsonBeans((ListableBeanFactory)beanFactory);
            }
            beanFactory = beanFactory instanceof HierarchicalBeanFactory ? ((HierarchicalBeanFactory)beanFactory).getParentBeanFactory() : null;
        }
    }

    private void addJsonBeans(ListableBeanFactory beanFactory) {
        Map<String, Object> beans2 = beanFactory.getBeansWithAnnotation(JsonComponent.class);
        for (Object bean2 : beans2.values()) {
            this.addJsonBean(bean2);
        }
    }

    private void addJsonBean(Object bean2) {
        if (bean2 instanceof JsonSerializer) {
            this.addSerializerWithDeducedType((JsonSerializer)bean2);
        }
        if (bean2 instanceof JsonDeserializer) {
            this.addDeserializerWithDeducedType((JsonDeserializer)bean2);
        }
        for (Class<?> innerClass : bean2.getClass().getDeclaredClasses()) {
            if (Modifier.isAbstract(innerClass.getModifiers()) || !JsonSerializer.class.isAssignableFrom(innerClass) && !JsonDeserializer.class.isAssignableFrom(innerClass)) continue;
            try {
                this.addJsonBean(innerClass.newInstance());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private <T> void addSerializerWithDeducedType(JsonSerializer<T> serializer) {
        ResolvableType type = ResolvableType.forClass(JsonSerializer.class, serializer.getClass());
        this.addSerializer(type.resolveGeneric(new int[0]), serializer);
    }

    private <T> void addDeserializerWithDeducedType(JsonDeserializer<T> deserializer) {
        ResolvableType type = ResolvableType.forClass(JsonDeserializer.class, deserializer.getClass());
        this.addDeserializer(type.resolveGeneric(new int[0]), deserializer);
    }
}

