/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics.analyzer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.util.ClassUtils;

class NoSuchMethodFailureAnalyzer
extends AbstractFailureAnalyzer<NoSuchMethodError> {
    NoSuchMethodFailureAnalyzer() {
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, NoSuchMethodError cause) {
        String className = this.extractClassName(cause);
        if (className == null) {
            return null;
        }
        List<URL> candidates = this.findCandidates(className);
        if (candidates == null) {
            return null;
        }
        URL actual = this.getActual(className);
        if (actual == null) {
            return null;
        }
        String description = this.getDescription(cause, className, candidates, actual);
        return new FailureAnalysis(description, "Correct the classpath of your application so that it contains a single, compatible version of " + className, cause);
    }

    private String extractClassName(NoSuchMethodError cause) {
        int descriptorIndex = cause.getMessage().indexOf(40);
        if (descriptorIndex == -1) {
            return null;
        }
        String classAndMethodName = cause.getMessage().substring(0, descriptorIndex);
        int methodNameIndex = classAndMethodName.lastIndexOf(46);
        if (methodNameIndex == -1) {
            return null;
        }
        return classAndMethodName.substring(0, methodNameIndex);
    }

    private List<URL> findCandidates(String className) {
        try {
            return Collections.list(NoSuchMethodFailureAnalyzer.class.getClassLoader().getResources(ClassUtils.convertClassNameToResourcePath(className) + ".class"));
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private URL getActual(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className).getProtectionDomain().getCodeSource().getLocation();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private String getDescription(NoSuchMethodError cause, String className, List<URL> candidates, URL actual) {
        StringWriter description = new StringWriter();
        PrintWriter writer = new PrintWriter(description);
        writer.print("An attempt was made to call the method ");
        writer.print(cause.getMessage());
        writer.print(" but it does not exist. Its class, ");
        writer.print(className);
        writer.println(", is available from the following locations:");
        writer.println();
        for (URL candidate : candidates) {
            writer.print("    ");
            writer.println(candidate);
        }
        writer.println();
        writer.println("It was loaded from the following location:");
        writer.println();
        writer.print("    ");
        writer.println(actual);
        return description.toString();
    }
}

