/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.RedissonSet;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.SortOrder;
import org.redisson.api.mapreduce.RCollectionMapReduce;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.TransactionalSet;
import org.redisson.transaction.operation.TransactionalOperation;

public class RedissonTransactionalSet<V>
extends RedissonSet<V> {
    private final TransactionalSet<V> transactionalSet;
    private final AtomicBoolean executed;

    public RedissonTransactionalSet(CommandAsyncExecutor commandExecutor, String name, List<TransactionalOperation> operations, long timeout, AtomicBoolean executed, String transactionId) {
        super(commandExecutor, name, null);
        this.executed = executed;
        RedissonSet innerSet = new RedissonSet(commandExecutor, name, null);
        this.transactionalSet = new TransactionalSet(commandExecutor, timeout, operations, innerSet, transactionId);
    }

    public RedissonTransactionalSet(Codec codec, CommandAsyncExecutor commandExecutor, String name, List<TransactionalOperation> operations, long timeout, AtomicBoolean executed, String transactionId) {
        super(codec, commandExecutor, name, null);
        this.executed = executed;
        RedissonSet innerSet = new RedissonSet(codec, commandExecutor, name, null);
        this.transactionalSet = new TransactionalSet(commandExecutor, timeout, operations, innerSet, transactionId);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAsync(Instant timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("clearExpire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        throw new UnsupportedOperationException("move method is not supported in transaction");
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        throw new UnsupportedOperationException("migrate method is not supported in transaction");
    }

    @Override
    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        throw new UnsupportedOperationException("mapReduce method is not supported in transaction");
    }

    @Override
    public ListScanResult<Object> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        this.checkState();
        return this.transactionalSet.scanIterator(name, client, startPos, pattern, count);
    }

    @Override
    public RLock getFairLock(V value) {
        throw new UnsupportedOperationException("getFairLock method is not supported in transaction");
    }

    @Override
    public RCountDownLatch getCountDownLatch(V value) {
        throw new UnsupportedOperationException("getCountDownLatch method is not supported in transaction");
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(V value) {
        throw new UnsupportedOperationException("getPermitExpirableSemaphore method is not supported in transaction");
    }

    @Override
    public RSemaphore getSemaphore(V value) {
        throw new UnsupportedOperationException("getSemaphore method is not supported in transaction");
    }

    @Override
    public RLock getLock(V value) {
        throw new UnsupportedOperationException("getLock method is not supported in transaction");
    }

    @Override
    public RReadWriteLock getReadWriteLock(V value) {
        throw new UnsupportedOperationException("getReadWriteLock method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        this.checkState();
        return this.transactionalSet.containsAsync(o);
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        this.checkState();
        return this.transactionalSet.readAllAsync();
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        this.checkState();
        return this.transactionalSet.addAsync(e);
    }

    @Override
    public RFuture<V> removeRandomAsync() {
        this.checkState();
        return this.transactionalSet.removeRandomAsync();
    }

    @Override
    public RFuture<Set<V>> removeRandomAsync(int amount) {
        this.checkState();
        return this.transactionalSet.removeRandomAsync(amount);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        this.checkState();
        return this.transactionalSet.removeAsync(o);
    }

    @Override
    public RFuture<Boolean> moveAsync(String destination, V member) {
        this.checkState();
        return this.transactionalSet.moveAsync(destination, member);
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        this.checkState();
        return this.transactionalSet.addAllAsync(c);
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        this.checkState();
        return this.transactionalSet.retainAllAsync(c);
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        this.checkState();
        return this.transactionalSet.removeAllAsync(c);
    }

    @Override
    public RFuture<Integer> unionAsync(String ... names) {
        this.checkState();
        return this.transactionalSet.unionAsync(names);
    }

    @Override
    public RFuture<Integer> diffAsync(String ... names) {
        this.checkState();
        return this.transactionalSet.diffAsync(names);
    }

    @Override
    public RFuture<Integer> intersectionAsync(String ... names) {
        this.checkState();
        return this.transactionalSet.intersectionAsync(names);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        this.checkState();
        return this.transactionalSet.readSortAsync(order);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        this.checkState();
        return this.transactionalSet.readSortAsync(order, offset, count);
    }

    @Override
    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        this.checkState();
        return this.transactionalSet.readSortAsync(byPattern, order);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        this.checkState();
        return this.transactionalSet.readSortAsync(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        return this.transactionalSet.readSortAlphaAsync(order);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        return this.transactionalSet.readSortAlphaAsync(order, offset, count);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        return this.transactionalSet.readSortAlphaAsync(byPattern, order);
    }

    @Override
    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        return this.transactionalSet.readSortAlphaAsync(byPattern, order, offset, count);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        return this.transactionalSet.readSortAlphaAsync(byPattern, getPatterns, order);
    }

    @Override
    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        return this.transactionalSet.readSortAlphaAsync(byPattern, getPatterns, order, offset, count);
    }

    @Override
    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        this.checkState();
        return this.transactionalSet.sortToAsync(destName, byPattern, getPatterns, order, offset, count);
    }

    @Override
    public RFuture<Set<V>> readUnionAsync(String ... names) {
        this.checkState();
        return this.transactionalSet.readUnionAsync(names);
    }

    @Override
    public RFuture<Set<V>> readDiffAsync(String ... names) {
        this.checkState();
        return this.transactionalSet.readDiffAsync(names);
    }

    @Override
    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        this.checkState();
        return this.transactionalSet.readIntersectionAsync(names);
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction is in finished state!");
        }
    }
}

