/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import org.redisson.spring.misc.BeanMethodInvoker;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RedissonNamespaceParserSupport {
    public static final String REDISSON_NAMESPACE = "http://redisson.org/schema/redisson";
    static final String REF_SUFFIX = "-ref";
    static final String API_CLASS_PATH_PREFIX = "org.redisson.api.R";
    static final String IMPL_CLASS_PATH_PREFIX = "org.redisson.Redisson";
    static final String ID_ATTRIBUTE = "id";
    static final String NAME_ATTRIBUTE = "name";
    static final String REDISSON_REF_ATTRIBUTE = "redisson-ref";
    static final String READ_WRITE_LOCK_REF_ATTRIBUTE = "read-write-lock-ref";
    static final String EXECUTOR_REF_ATTRIBUTE = "executor-ref";
    static final String REMOTE_SERVICE_REF_ATTRIBUTE = "remote-service-ref";
    static final String LIVE_OBJECT_SERVICE_REF_ATTRIBUTE = "live-object-service-ref";
    static final String OBJECT_ID_REF_ATTRIBUTE = "object-id-ref";
    static final String MAX_IDLE_ATTRIBUTE = "max-idle";
    static final String TIME_TO_LIVE_ATTRIBUTE = "time-to-live";
    static final String MAX_IDLE_UNIT_ATTRIBUTE = "max-idle-unit";
    static final String TIME_TO_LIVE_UNIT_ATTRIBUTE = "time-to-live-unit";
    static final String CONCURRENT_WORKERS_ATTRIBUTE = "concurrent-workers";
    static final String WITHIN_ATTRIBUTE = "within";
    static final String TIME_UNIT_ATTRIBUTE = "time-unit";
    static final String API_CLASS_ATTRIBUTE = "api-class";
    static final String CLASS_ATTRIBUTE = "class";
    static final String OBJECT_ID_ATTRIBUTE = "object-id";
    static final String READ_LOCK_ELEMENT = "read-lock";
    static final String WRITE_LOCK_ELEMENT = "write-lock";
    static final String RPC_SERVER_ELEMENT = "rpc-server";
    static final String RPC_CLIENT_ELEMENT = "rpc-client";
    static final String REMOTE_INVOCATION_OPTIONS_ELEMENT = "remote-invocation-options";
    static final String REMOTE_NO_ACK_ELEMENT = "remote-no-ack";
    static final String REMOTE_ACK_ELEMENT = "remote-ack";
    static final String REMOTE_NO_RESULT_ELEMENT = "remote-no-result";
    static final String REMOTE_RESULT_ELEMENT = "remote-result";
    static final String LOCAL_CACHED_MAP_OPTIONS_ELEMENT = "local-cached-map-options";
    static final String LIVE_OBJECT_ELEMENT = "live-object";
    static final String LIVE_OBJECT_REGISTRATION_ELEMENT = "live-object-registration";

    public String[] parseAliase(Element element) {
        if (element == null) {
            return null;
        }
        String[] aliases = null;
        String name = element.getAttribute(NAME_ATTRIBUTE);
        if (StringUtils.hasLength(name)) {
            aliases = StringUtils.trimArrayElements(StringUtils.commaDelimitedListToStringArray(name));
        }
        return aliases;
    }

    public void parseAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            if (!this.isEligibleAttribute(attribute)) continue;
            String propertyName = attribute.getLocalName();
            if (propertyName.endsWith(REF_SUFFIX)) {
                propertyName = propertyName.substring(0, attribute.getLocalName().length() - REF_SUFFIX.length());
            }
            propertyName = Conventions.attributeNameToPropertyName(propertyName);
            Assert.state(StringUtils.hasText(propertyName), "Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            if (attribute.getLocalName().endsWith(REF_SUFFIX)) {
                builder.addPropertyReference(propertyName, attribute.getValue());
                continue;
            }
            builder.addPropertyValue(propertyName, attribute.getValue());
        }
    }

    public BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, ParserContext parserContext, Class<?> cls) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        builder.getRawBeanDefinition().setBeanClass(cls);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource(element));
        if (parserContext.isNested()) {
            builder.setScope(parserContext.getContainingBeanDefinition().getScope());
        }
        if (parserContext.isDefaultLazyInit()) {
            builder.setLazyInit(true);
        }
        return builder;
    }

    public BeanComponentDefinition registerBeanDefinition(BeanDefinitionBuilder builder, String id, String[] aliases, ParserContext parserContext) {
        BeanDefinitionHolder holder = new BeanDefinitionHolder(builder.getBeanDefinition(), id, aliases);
        BeanDefinitionReaderUtils.registerBeanDefinition(holder, parserContext.getRegistry());
        BeanComponentDefinition componentDefinition = new BeanComponentDefinition(holder);
        parserContext.registerComponent(componentDefinition);
        return componentDefinition;
    }

    public BeanComponentDefinition registerBeanDefinition(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        BeanDefinitionHolder holder = new BeanDefinitionHolder(builder.getBeanDefinition(), this.getId(element, builder, parserContext), this.parseAliase(element));
        BeanDefinitionReaderUtils.registerBeanDefinition(holder, parserContext.getRegistry());
        BeanComponentDefinition componentDefinition = new BeanComponentDefinition(holder);
        parserContext.registerComponent(componentDefinition);
        return componentDefinition;
    }

    public void addConstructorArgs(Element element, String attribute, Class<?> type, BeanDefinition bd) {
        if (element.hasAttribute(attribute)) {
            this.addConstructorArgs((Object)element.getAttribute(attribute), type, bd);
        }
    }

    public void addConstructorArgs(Object value, Class<?> type, BeanDefinition bd) {
        ConstructorArgumentValues.ValueHolder vHolder = new ConstructorArgumentValues.ValueHolder(value, type.getName());
        ConstructorArgumentValues args = bd.getConstructorArgumentValues();
        args.addIndexedArgumentValue(args.getArgumentCount(), vHolder);
    }

    public void addConstructorArgs(Element element, String attribute, Class<?> type, BeanDefinitionBuilder builder) {
        this.addConstructorArgs(element, attribute, type, builder.getRawBeanDefinition());
    }

    public void addConstructorArgs(Object value, Class<?> type, BeanDefinitionBuilder builder) {
        this.addConstructorArgs(value, type, builder.getRawBeanDefinition());
    }

    public String getName(Node node) {
        return Conventions.attributeNameToPropertyName(node.getLocalName());
    }

    public String getId(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        String id = null;
        if (element != null) {
            id = element.getAttribute(ID_ATTRIBUTE);
        }
        if (!StringUtils.hasText(id)) {
            id = this.generateId(builder, parserContext);
        }
        return id;
    }

    public String generateId(BeanDefinitionBuilder builder, ParserContext parserContext) {
        return parserContext.getReaderContext().generateBeanName(builder.getRawBeanDefinition());
    }

    public void populateIdAttribute(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        if (element == null) {
            return;
        }
        if (!StringUtils.hasText(element.getAttribute(ID_ATTRIBUTE))) {
            element.setAttribute(ID_ATTRIBUTE, this.generateId(builder, parserContext));
        }
    }

    public BeanComponentDefinition factoryInvoker(Element element, String bean2, String method, Object[] args, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.preInvoke(element, bean2, method, args, parserContext, true);
        builder.addPropertyReference("targetObject", bean2);
        return this.doInvoke(element, builder, parserContext);
    }

    public BeanComponentDefinition factoryInvoker(Element element, Object obj, String method, Object[] args, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.preInvoke(element, obj, method, args, parserContext, true);
        builder.addPropertyValue("targetObject", obj);
        return this.doInvoke(element, builder, parserContext);
    }

    public BeanComponentDefinition factoryInvoker(String bean2, String method, Object[] args, ParserContext parserContext) {
        return this.factoryInvoker(null, bean2, method, args, parserContext);
    }

    public BeanComponentDefinition factoryInvoker(Object obj, String method, Object[] args, ParserContext parserContext) {
        return this.factoryInvoker(null, obj, method, args, parserContext);
    }

    public BeanComponentDefinition invoker(Element element, String bean2, String method, Object[] args, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.preInvoke(element, bean2, method, args, parserContext, false);
        builder.addPropertyReference("targetObject", bean2);
        return this.doInvoke(element, builder, parserContext);
    }

    public BeanComponentDefinition invoker(Element element, Object obj, String method, Object[] args, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.preInvoke(element, obj, method, args, parserContext, false);
        builder.addPropertyValue("targetObject", obj);
        return this.doInvoke(element, builder, parserContext);
    }

    public BeanComponentDefinition invoker(String bean2, String method, Object[] args, ParserContext parserContext) {
        return this.invoker(null, bean2, method, args, parserContext);
    }

    public BeanComponentDefinition invoker(Object obj, String method, Object[] args, ParserContext parserContext) {
        return this.invoker(null, obj, method, args, parserContext);
    }

    private BeanDefinitionBuilder preInvoke(Element element, Object obj, String method, Object[] args, ParserContext parserContext, boolean factory) {
        Class beanClass = BeanMethodInvoker.class;
        if (factory) {
            beanClass = MethodInvokingFactoryBean.class;
        }
        BeanDefinitionBuilder builder = this.createBeanDefinitionBuilder(element, parserContext, beanClass);
        if (obj instanceof Class) {
            builder.addPropertyValue("staticMethod", ((Class)obj).getName() + "." + method);
        } else {
            builder.addPropertyValue("targetMethod", method);
        }
        builder.addPropertyValue("arguments", args);
        if (element != null) {
            parserContext.getDelegate().parseQualifierElements(element, builder.getRawBeanDefinition());
        }
        return builder;
    }

    private BeanComponentDefinition doInvoke(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        String id = this.getId(element, builder, parserContext);
        return this.registerBeanDefinition(builder, id, this.parseAliase(element), parserContext);
    }

    public boolean isEligibleAttribute(String attributeName) {
        return !"xmlns".equals(attributeName) && !attributeName.startsWith("xmlns:") && !ID_ATTRIBUTE.equals(attributeName) && !NAME_ATTRIBUTE.equals(attributeName);
    }

    public boolean isEligibleAttribute(Attr attribute) {
        return this.isEligibleAttribute(attribute.getName());
    }

    public boolean isRedissonNS(Node node) {
        return node != null && REDISSON_NAMESPACE.equals(node.getNamespaceURI());
    }

    public String getAttribute(Element element, String attribute) {
        return element.getAttribute(attribute);
    }

    public void setAttribute(Element element, String attribute, String value) {
        element.setAttribute(attribute, value);
    }

    public boolean hasAttribute(Element element, String attribute) {
        return element.hasAttribute(attribute);
    }

    public boolean hasElement(Element element, String tagName) {
        return element.getElementsByTagNameNS(REDISSON_NAMESPACE, tagName).getLength() > 0;
    }

    public Element getSingleElement(Element element, String tagName) {
        return (Element)element.getElementsByTagNameNS(REDISSON_NAMESPACE, tagName).item(0);
    }
}

