/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.nio.ByteBuffer;
import org.redisson.RedissonBinaryStream;
import org.redisson.api.RBinaryStream;
import org.redisson.api.RFuture;
import org.redisson.reactive.CommandReactiveExecutor;
import reactor.core.publisher.Mono;

public class RedissonBinaryStreamReactive {
    private final CommandReactiveExecutor commandExecutor;
    private final RedissonBinaryStream.RedissonAsynchronousByteChannel channel;

    public RedissonBinaryStreamReactive(CommandReactiveExecutor commandExecutor, RBinaryStream stream) {
        this.commandExecutor = commandExecutor;
        this.channel = (RedissonBinaryStream.RedissonAsynchronousByteChannel)stream.getAsynchronousChannel();
    }

    public long position() {
        return this.channel.position();
    }

    public void position(long newPosition) {
        this.channel.position(newPosition);
    }

    public Mono<Integer> read(ByteBuffer buf) {
        return this.commandExecutor.reactive(() -> (RFuture)this.channel.read(buf));
    }

    public Mono<Integer> write(ByteBuffer buf) {
        return this.commandExecutor.reactive(() -> (RFuture)this.channel.write(buf));
    }
}

