/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.BatchCommandData;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.BatchPromise;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandAsyncService;
import org.redisson.command.RedisBatchExecutor;
import org.redisson.command.RedisCommonBatchExecutor;
import org.redisson.command.RedisExecutor;
import org.redisson.command.RedisQueuedBatchExecutor;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.AsyncCountDownLatch;
import org.redisson.misc.CountableListener;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class CommandBatchService
extends CommandAsyncService {
    private final AsyncCountDownLatch latch = new AsyncCountDownLatch();
    private final AtomicInteger index = new AtomicInteger();
    private final ConcurrentMap<MasterSlaveEntry, Entry> commands = new ConcurrentHashMap<MasterSlaveEntry, Entry>();
    private final ConcurrentMap<MasterSlaveEntry, ConnectionEntry> connections = new ConcurrentHashMap<MasterSlaveEntry, ConnectionEntry>();
    private final BatchOptions options;
    private final Map<RFuture<?>, List<CommandBatchService>> nestedServices = new ConcurrentHashMap();
    private final AtomicBoolean executed = new AtomicBoolean();

    public CommandBatchService(CommandAsyncExecutor executor) {
        this(executor, RedissonObjectBuilder.ReferenceType.DEFAULT);
    }

    public CommandBatchService(CommandAsyncExecutor executor, RedissonObjectBuilder.ReferenceType referenceType) {
        this(executor.getConnectionManager(), BatchOptions.defaults(), executor.getObjectBuilder(), referenceType);
    }

    public CommandBatchService(CommandAsyncExecutor executor, BatchOptions options) {
        this(executor.getConnectionManager(), options, executor.getObjectBuilder(), RedissonObjectBuilder.ReferenceType.DEFAULT);
    }

    public CommandBatchService(CommandAsyncExecutor executor, BatchOptions options, RedissonObjectBuilder.ReferenceType referenceType) {
        this(executor.getConnectionManager(), options, executor.getObjectBuilder(), referenceType);
    }

    private CommandBatchService(ConnectionManager connectionManager, BatchOptions options, RedissonObjectBuilder objectBuilder, RedissonObjectBuilder.ReferenceType referenceType) {
        super(connectionManager, objectBuilder, referenceType);
        this.options = options;
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    public void add(RFuture<?> future, List<CommandBatchService> services) {
        this.nestedServices.put(future, services);
    }

    @Override
    public <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, boolean ignoreRedirect) {
        if (this.isRedisBasedQueue()) {
            boolean isReadOnly = this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC;
            RedisQueuedBatchExecutor<V, R> executor = new RedisQueuedBatchExecutor<V, R>(isReadOnly, nodeSource, codec, command, params, mainPromise, false, this.connectionManager, this.objectBuilder, this.commands, this.connections, this.options, this.index, this.executed, this.latch, this.referenceType);
            ((RedisExecutor)executor).execute();
        } else {
            RedisBatchExecutor<V, R> executor = new RedisBatchExecutor<V, R>(readOnlyMode, nodeSource, codec, command, params, mainPromise, false, this.connectionManager, this.objectBuilder, this.commands, this.options, this.index, this.executed, this.referenceType);
            ((RedisExecutor)executor).execute();
        }
    }

    @Override
    public <R> RPromise<R> createPromise() {
        if (this.isRedisBasedQueue()) {
            return new BatchPromise(this.executed);
        }
        return new RedissonPromise();
    }

    public BatchResult<?> execute() {
        RFuture<BatchResult<?>> f = this.executeAsync();
        return this.get(f);
    }

    public RFuture<Void> executeAsyncVoid() {
        RedissonPromise<Void> promise = new RedissonPromise<Void>();
        RFuture<BatchResult<?>> resFuture = this.executeAsync();
        resFuture.onComplete((res, e) -> {
            if (e == null) {
                promise.trySuccess(null);
            } else {
                promise.tryFailure((Throwable)e);
            }
        });
        return promise;
    }

    public boolean isExecuted() {
        return this.executed.get();
    }

    public RFuture<BatchResult<?>> executeAsync() {
        if (this.executed.get()) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty()) {
            this.executed.set(true);
            BatchResult result = new BatchResult(Collections.emptyList(), 0);
            return RedissonPromise.newSucceededFuture(result);
        }
        if (this.isRedisBasedQueue()) {
            return this.executeRedisBasedQueue();
        }
        if (this.options.getExecutionMode() != BatchOptions.ExecutionMode.IN_MEMORY) {
            for (Entry entry : this.commands.values()) {
                BatchCommandData multiCommand = new BatchCommandData(RedisCommands.MULTI, new Object[0], this.index.incrementAndGet());
                entry.getCommands().addFirst(multiCommand);
                BatchCommandData execCommand = new BatchCommandData(RedisCommands.EXEC, new Object[0], this.index.incrementAndGet());
                entry.getCommands().add(execCommand);
            }
        }
        if (this.options.isSkipResult()) {
            for (Entry entry : this.commands.values()) {
                BatchCommandData offCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"OFF"}, this.index.incrementAndGet());
                entry.getCommands().addFirst(offCommand);
                BatchCommandData onCommand = new BatchCommandData(RedisCommands.CLIENT_REPLY, new Object[]{"ON"}, this.index.incrementAndGet());
                entry.getCommands().add(onCommand);
            }
        }
        if (this.options.getSyncSlaves() > 0) {
            for (Entry entry : this.commands.values()) {
                BatchCommandData waitCommand = new BatchCommandData(RedisCommands.WAIT, new Object[]{this.options.getSyncSlaves(), this.options.getSyncTimeout()}, this.index.incrementAndGet());
                entry.getCommands().add(waitCommand);
            }
        }
        RedissonPromise promise = new RedissonPromise();
        RedissonPromise<Void> voidPromise = new RedissonPromise<Void>();
        if (this.options.isSkipResult() && this.options.getSyncSlaves() == 0) {
            voidPromise.onComplete((res, ex) -> {
                this.executed.set(true);
                if (ex != null) {
                    for (Entry e : this.commands.values()) {
                        e.getCommands().forEach(t -> t.tryFailure((Throwable)ex));
                    }
                    promise.tryFailure((Throwable)ex);
                    this.commands.clear();
                    this.nestedServices.clear();
                    return;
                }
                this.commands.clear();
                this.nestedServices.clear();
                promise.trySuccess(new BatchResult(Collections.emptyList(), 0));
            });
        } else {
            voidPromise.onComplete((res, ex) -> {
                this.executed.set(true);
                if (ex != null) {
                    for (Entry e : this.commands.values()) {
                        e.getCommands().forEach(t -> t.tryFailure((Throwable)ex));
                    }
                    promise.tryFailure((Throwable)ex);
                    this.commands.clear();
                    this.nestedServices.clear();
                    return;
                }
                ArrayList entries = new ArrayList();
                for (Entry e : this.commands.values()) {
                    entries.addAll(e.getCommands());
                }
                Collections.sort(entries);
                ArrayList responses = new ArrayList(entries.size());
                int syncedSlaves = 0;
                for (BatchCommandData batchCommandData : entries) {
                    if (this.isWaitCommand(batchCommandData)) {
                        syncedSlaves = (Integer)batchCommandData.getPromise().getNow();
                        continue;
                    }
                    if (batchCommandData.getCommand().getName().equals(RedisCommands.MULTI.getName()) || batchCommandData.getCommand().getName().equals(RedisCommands.EXEC.getName()) || this.options.isSkipResult() || batchCommandData.getPromise().isCancelled()) continue;
                    Object entryResult = batchCommandData.getPromise().getNow();
                    try {
                        if (this.objectBuilder != null) {
                            entryResult = this.objectBuilder.tryHandleReference(entryResult, this.referenceType);
                        }
                    }
                    catch (ReflectiveOperationException exc) {
                        log.error("Unable to handle reference from " + entryResult, exc);
                    }
                    responses.add(entryResult);
                }
                BatchResult result = new BatchResult(responses, syncedSlaves);
                promise.trySuccess(result);
                this.commands.clear();
                this.nestedServices.clear();
            });
        }
        AtomicInteger slots = new AtomicInteger(this.commands.size());
        for (Map.Entry<RFuture<?>, List<CommandBatchService>> entry : this.nestedServices.entrySet()) {
            slots.incrementAndGet();
            for (CommandBatchService service : entry.getValue()) {
                service.executeAsync();
            }
            entry.getKey().onComplete((res, e) -> this.handle(voidPromise, slots, (RFuture)entry.getKey()));
        }
        for (Map.Entry<RFuture<Object>, List<CommandBatchService>> entry : this.commands.entrySet()) {
            RedisCommonBatchExecutor executor = new RedisCommonBatchExecutor(new NodeSource((MasterSlaveEntry)((Object)entry.getKey())), voidPromise, this.connectionManager, this.options, (Entry)((Object)entry.getValue()), slots, this.referenceType);
            executor.execute();
        }
        return promise;
    }

    private <R> RFuture<R> executeRedisBasedQueue() {
        int permits = 0;
        for (Entry entry : this.commands.values()) {
            permits += entry.getCommands().size();
        }
        final RedissonPromise resultPromise = new RedissonPromise();
        final long responseTimeout = this.options.getResponseTimeout() > 0L ? this.options.getResponseTimeout() : (long)this.connectionManager.getConfig().getTimeout();
        final Timeout timeout = this.connectionManager.newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                resultPromise.tryFailure(new RedisTimeoutException("Response timeout for queued commands " + responseTimeout + ": " + CommandBatchService.this.commands.values().stream().flatMap(e -> e.getCommands().stream().map(d -> d.getCommand())).collect(Collectors.toList())));
            }
        }, responseTimeout, TimeUnit.MILLISECONDS);
        this.latch.latch(new Runnable(){

            @Override
            public void run() {
                if (!timeout.cancel()) {
                    return;
                }
                block0: for (Entry entry : CommandBatchService.this.commands.values()) {
                    for (BatchCommandData<?, ?> command : entry.getCommands()) {
                        if (!command.getPromise().isDone() || command.getPromise().isSuccess()) continue;
                        resultPromise.tryFailure(command.getPromise().cause());
                        continue block0;
                    }
                }
                if (resultPromise.isDone()) {
                    return;
                }
                RedissonPromise mainPromise = new RedissonPromise();
                ConcurrentHashMap result = new ConcurrentHashMap();
                CountableListener listener = new CountableListener(mainPromise, result);
                listener.setCounter(CommandBatchService.this.connections.size());
                for (Map.Entry entry : CommandBatchService.this.commands.entrySet()) {
                    RedissonPromise execPromise = new RedissonPromise();
                    CommandBatchService.this.async(((Entry)entry.getValue()).isReadOnlyMode(), new NodeSource((MasterSlaveEntry)entry.getKey()), CommandBatchService.this.connectionManager.getCodec(), RedisCommands.EXEC, new Object[0], execPromise, false);
                    execPromise.onComplete((r, ex) -> {
                        if (ex != null) {
                            mainPromise.tryFailure((Throwable)ex);
                            return;
                        }
                        BatchCommandData<?, ?> lastCommand = ((Entry)entry.getValue()).getCommands().peekLast();
                        result.put(entry.getKey(), r);
                        if (RedisCommands.WAIT.getName().equals(lastCommand.getCommand().getName())) {
                            lastCommand.getPromise().onComplete((res, e) -> {
                                if (e != null) {
                                    mainPromise.tryFailure((Throwable)e);
                                    return;
                                }
                                execPromise.onComplete(listener);
                            });
                        } else {
                            execPromise.onComplete(listener);
                        }
                    });
                }
                mainPromise.onComplete((res, ex) -> {
                    CommandBatchService.this.executed.set(true);
                    if (ex != null) {
                        resultPromise.tryFailure((Throwable)ex);
                        return;
                    }
                    try {
                        for (Map.Entry entry : res.entrySet()) {
                            Entry commandEntry = (Entry)CommandBatchService.this.commands.get(entry.getKey());
                            Iterator resultIter = ((List)entry.getValue()).iterator();
                            for (BatchCommandData<?, ?> data : commandEntry.getCommands()) {
                                if (data.getCommand().getName().equals(RedisCommands.EXEC.getName())) break;
                                RPromise promise = data.getPromise();
                                if (resultIter.hasNext()) {
                                    promise.trySuccess(resultIter.next());
                                    continue;
                                }
                                promise.trySuccess(null);
                            }
                        }
                        ArrayList entries = new ArrayList();
                        for (Entry e : CommandBatchService.this.commands.values()) {
                            entries.addAll(e.getCommands());
                        }
                        Collections.sort(entries);
                        ArrayList arrayList = new ArrayList(entries.size());
                        int syncedSlaves = 0;
                        for (BatchCommandData batchCommandData : entries) {
                            if (CommandBatchService.this.isWaitCommand(batchCommandData)) {
                                syncedSlaves += ((Integer)batchCommandData.getPromise().getNow()).intValue();
                                continue;
                            }
                            if (batchCommandData.getCommand().getName().equals(RedisCommands.MULTI.getName()) || batchCommandData.getCommand().getName().equals(RedisCommands.EXEC.getName())) continue;
                            Object entryResult = batchCommandData.getPromise().getNow();
                            if (CommandBatchService.this.objectBuilder != null) {
                                entryResult = CommandBatchService.this.objectBuilder.tryHandleReference(entryResult, CommandBatchService.this.referenceType);
                            }
                            arrayList.add(entryResult);
                        }
                        BatchResult r = new BatchResult(arrayList, syncedSlaves);
                        resultPromise.trySuccess(r);
                    }
                    catch (Exception e) {
                        resultPromise.tryFailure(e);
                    }
                });
            }
        }, permits);
        return resultPromise;
    }

    protected boolean isRedisBasedQueue() {
        return this.options != null && (this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_READ_ATOMIC || this.options.getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC);
    }

    protected boolean isWaitCommand(CommandData<?, ?> c) {
        return c.getCommand().getName().equals(RedisCommands.WAIT.getName());
    }

    protected void handle(RPromise<Void> mainPromise, AtomicInteger slots, RFuture<?> future) {
        if (future.isSuccess()) {
            if (slots.decrementAndGet() == 0) {
                mainPromise.trySuccess(null);
            }
        } else {
            mainPromise.tryFailure(future.cause());
        }
    }

    @Override
    protected boolean isEvalCacheActive() {
        return false;
    }

    public static class Entry {
        Deque<BatchCommandData<?, ?>> commands = new LinkedBlockingDeque();
        volatile boolean readOnlyMode = true;

        public Deque<BatchCommandData<?, ?>> getCommands() {
            return this.commands;
        }

        public void setReadOnlyMode(boolean readOnlyMode) {
            this.readOnlyMode = readOnlyMode;
        }

        public boolean isReadOnlyMode() {
            return this.readOnlyMode;
        }

        public void clearErrors() {
            for (BatchCommandData<?, ?> commandEntry : this.commands) {
                commandEntry.clearError();
            }
        }
    }

    public static class ConnectionEntry {
        boolean firstCommand = true;
        RFuture<RedisConnection> connectionFuture;

        public RFuture<RedisConnection> getConnectionFuture() {
            return this.connectionFuture;
        }

        public void setConnectionFuture(RFuture<RedisConnection> connectionFuture) {
            this.connectionFuture = connectionFuture;
        }

        public boolean isFirstCommand() {
            return this.firstCommand;
        }

        public void setFirstCommand(boolean firstCommand) {
            this.firstCommand = firstCommand;
        }
    }
}

