/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.function.Supplier;
import jodd.bean.BeanUtilBean;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.Getter;
import jodd.introspector.PropertyDescriptor;
import jodd.introspector.Setter;

class BeanProperty {
    final String fullName;
    final ClassIntrospector introspector;
    Object bean;
    private ClassDescriptor cd;
    String name;
    boolean last;
    boolean first;
    String indexString;
    private boolean updateProperty = true;
    private PropertyDescriptor propertyDescriptor;
    String index;

    BeanProperty(BeanUtilBean beanUtilBean, Object bean2, String propertyName) {
        this.introspector = beanUtilBean.introspector;
        this.setName(propertyName);
        this.updateBean(bean2);
        this.last = true;
        this.first = true;
        this.fullName = bean2.getClass().getSimpleName() + '#' + propertyName;
    }

    public void setName(String name) {
        this.name = name;
        this.updateProperty = true;
    }

    private void setBean(Object bean2) {
        this.bean = bean2;
        this.cd = bean2 == null ? null : this.introspector.lookup(bean2.getClass());
        this.first = false;
        this.updateProperty = true;
    }

    public void updateBean(Object bean2) {
        this.setBean(bean2);
        if (this.cd != null && this.cd.isSupplier()) {
            Object newBean = ((Supplier)this.bean).get();
            this.setBean(newBean);
        }
    }

    private void loadPropertyDescriptor() {
        if (this.updateProperty) {
            this.propertyDescriptor = this.cd == null ? null : this.cd.getPropertyDescriptor(this.name, true);
            this.updateProperty = false;
        }
    }

    public Getter getGetter(boolean declared) {
        this.loadPropertyDescriptor();
        return this.propertyDescriptor != null ? this.propertyDescriptor.getGetter(declared) : null;
    }

    public Setter getSetter(boolean declared) {
        this.loadPropertyDescriptor();
        return this.propertyDescriptor != null ? this.propertyDescriptor.getSetter(declared) : null;
    }

    public boolean isMap() {
        return this.cd != null && this.cd.isMap();
    }

    public String toString() {
        return this.fullName + " (" + (this.bean != null ? this.bean.getClass().getSimpleName() : "?") + '#' + this.name + ')';
    }
}

