/*
 * Decompiled with CFR 0.152.
 */
package com.riven.redisson.config;

import com.riven.redisson.config.QueueRegistryInfo;
import com.riven.redisson.config.RedissonQueue;
import com.riven.redisson.config.RedissonQueueRegistry;
import com.riven.redisson.handler.IsolationStrategy;
import com.riven.redisson.message.FastJsonCodec;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;

public class RedissonQueueBeanPostProcessor
implements BeanFactoryAware,
BeanPostProcessor {
    private BeanFactory beanFactory;
    private RedissonClient redissonClient;
    private RedissonQueueRegistry redissonQueueRegistry;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.redissonClient = this.beanFactory.getBean(RedissonClient.class);
        this.redissonQueueRegistry = this.beanFactory.getBean("com.riven.redisson.internalRedissonQueueRegistry", RedissonQueueRegistry.class);
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof RedissonQueue) {
            RedissonQueue redissonQueue = (RedissonQueue)bean2;
            QueueRegistryInfo registryInfo = new QueueRegistryInfo();
            String queueName = redissonQueue.getQueue();
            QueueRegistryInfo registeredInfo = this.redissonQueueRegistry.getRegistryInfo(queueName);
            if (registeredInfo != null) {
                throw new BeanDefinitionValidationException("duplicate bean of RedissonQueue named [" + queueName + "]");
            }
            IsolationStrategy isolationHandler = redissonQueue.getIsolationHandler();
            String isolatedName = isolationHandler == null ? queueName : isolationHandler.getRedisQueueName(queueName);
            RBlockingQueue<Object> blockingQueue = this.redissonClient.getBlockingQueue(isolatedName, FastJsonCodec.INSTANCE);
            RDelayedQueue<Object> delayedQueue = null;
            if (redissonQueue.isDelay()) {
                delayedQueue = this.redissonClient.getDelayedQueue(blockingQueue);
            }
            registryInfo.setQueueName(queueName);
            registryInfo.setIsolatedName(isolatedName);
            registryInfo.setQueue(redissonQueue);
            registryInfo.setIsolationHandler(isolationHandler);
            registryInfo.setMessageConverter(redissonQueue.getMessageConverter());
            registryInfo.setBlockingQueue(blockingQueue);
            registryInfo.setDelayedQueue(delayedQueue);
            this.redissonQueueRegistry.registerQueueInfo(queueName, registryInfo);
        }
        return bean2;
    }
}

