/*
 * Decompiled with CFR 0.152.
 */
package com.riven.redisson.config;

import com.riven.redisson.listener.RedissonListenerContainer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;

public class RedissonListenerRegistry
implements SmartLifecycle {
    private List<RedissonListenerContainer> listenerContainers = new ArrayList<RedissonListenerContainer>(8);

    public void registerListenerContainer(RedissonListenerContainer listenerContainer) {
        this.listenerContainers.add(listenerContainer);
    }

    @PreDestroy
    public void destroy() {
        this.stop();
    }

    @Override
    public boolean isAutoStartup() {
        return true;
    }

    @Override
    public void stop(Runnable callback) {
        this.listenerContainers.forEach(listenerContainer -> listenerContainer.stop(callback));
    }

    @Override
    public void start() {
        this.listenerContainers.forEach(Lifecycle::start);
    }

    @Override
    public void stop() {
        this.listenerContainers.forEach(Lifecycle::stop);
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public int getPhase() {
        return Integer.MAX_VALUE;
    }
}

