/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import java.time.Duration;
import java.util.Objects;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitMessagingTemplate;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.RabbitAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@EnableConfigurationProperties(value={RabbitProperties.class})
@Import(value={RabbitAnnotationDrivenConfiguration.class})
public class RabbitAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={RabbitMessagingTemplate.class})
    @ConditionalOnMissingBean(value={RabbitMessagingTemplate.class})
    @Import(value={RabbitTemplateConfiguration.class})
    protected static class MessagingTemplateConfiguration {
        protected MessagingTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnSingleCandidate(value=RabbitTemplate.class)
        public RabbitMessagingTemplate rabbitMessagingTemplate(RabbitTemplate rabbitTemplate) {
            return new RabbitMessagingTemplate(rabbitTemplate);
        }
    }

    @Configuration
    @Import(value={RabbitConnectionFactoryCreator.class})
    protected static class RabbitTemplateConfiguration {
        private final ObjectProvider<MessageConverter> messageConverter;
        private final RabbitProperties properties;

        public RabbitTemplateConfiguration(ObjectProvider<MessageConverter> messageConverter, RabbitProperties properties) {
            this.messageConverter = messageConverter;
            this.properties = properties;
        }

        @Bean
        @ConditionalOnSingleCandidate(value=org.springframework.amqp.rabbit.connection.ConnectionFactory.class)
        @ConditionalOnMissingBean
        public RabbitTemplate rabbitTemplate(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            PropertyMapper map = PropertyMapper.get();
            RabbitTemplate template = new RabbitTemplate(connectionFactory);
            MessageConverter messageConverter = this.messageConverter.getIfUnique();
            if (messageConverter != null) {
                template.setMessageConverter(messageConverter);
            }
            template.setMandatory(this.determineMandatoryFlag());
            RabbitProperties.Template properties = this.properties.getTemplate();
            if (properties.getRetry().isEnabled()) {
                template.setRetryTemplate(this.createRetryTemplate(properties.getRetry()));
            }
            map.from(properties::getReceiveTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((RabbitTemplate)template).setReceiveTimeout(arg_0));
            map.from(properties::getReplyTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((RabbitTemplate)template).setReplyTimeout(arg_0));
            map.from(properties::getExchange).to(arg_0 -> ((RabbitTemplate)template).setExchange(arg_0));
            map.from(properties::getRoutingKey).to(arg_0 -> ((RabbitTemplate)template).setRoutingKey(arg_0));
            return template;
        }

        private boolean determineMandatoryFlag() {
            Boolean mandatory = this.properties.getTemplate().getMandatory();
            return mandatory != null ? mandatory.booleanValue() : this.properties.isPublisherReturns();
        }

        private RetryTemplate createRetryTemplate(RabbitProperties.Retry properties) {
            PropertyMapper map = PropertyMapper.get();
            RetryTemplate template = new RetryTemplate();
            SimpleRetryPolicy policy = new SimpleRetryPolicy();
            map.from(properties::getMaxAttempts).to(arg_0 -> ((SimpleRetryPolicy)policy).setMaxAttempts(arg_0));
            template.setRetryPolicy((RetryPolicy)policy);
            ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
            map.from(properties::getInitialInterval).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((ExponentialBackOffPolicy)backOffPolicy).setInitialInterval(arg_0));
            map.from(properties::getMultiplier).to(arg_0 -> ((ExponentialBackOffPolicy)backOffPolicy).setMultiplier(arg_0));
            map.from(properties::getMaxInterval).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((ExponentialBackOffPolicy)backOffPolicy).setMaxInterval(arg_0));
            template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
            return template;
        }

        @Bean
        @ConditionalOnSingleCandidate(value=org.springframework.amqp.rabbit.connection.ConnectionFactory.class)
        @ConditionalOnProperty(prefix="spring.rabbitmq", name={"dynamic"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public AmqpAdmin amqpAdmin(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            return new RabbitAdmin(connectionFactory);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={org.springframework.amqp.rabbit.connection.ConnectionFactory.class})
    protected static class RabbitConnectionFactoryCreator {
        private static final boolean CAN_ENABLE_HOSTNAME_VERIFICATION = ReflectionUtils.findMethod(ConnectionFactory.class, "enableHostnameVerification") != null;

        protected RabbitConnectionFactoryCreator() {
        }

        @Bean
        public CachingConnectionFactory rabbitConnectionFactory(RabbitProperties properties, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy) throws Exception {
            PropertyMapper map = PropertyMapper.get();
            CachingConnectionFactory factory = new CachingConnectionFactory((ConnectionFactory)this.getRabbitConnectionFactoryBean(properties).getObject());
            map.from(properties::determineAddresses).to(arg_0 -> ((CachingConnectionFactory)factory).setAddresses(arg_0));
            map.from(properties::isPublisherConfirms).to(arg_0 -> ((CachingConnectionFactory)factory).setPublisherConfirms(arg_0));
            map.from(properties::isPublisherReturns).to(arg_0 -> ((CachingConnectionFactory)factory).setPublisherReturns(arg_0));
            RabbitProperties.Cache.Channel channel = properties.getCache().getChannel();
            map.from(channel::getSize).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setChannelCacheSize(arg_0));
            map.from(channel::getCheckoutTimeout).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((CachingConnectionFactory)factory).setChannelCheckoutTimeout(arg_0));
            RabbitProperties.Cache.Connection connection = properties.getCache().getConnection();
            map.from(connection::getMode).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setCacheMode(arg_0));
            map.from(connection::getSize).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setConnectionCacheSize(arg_0));
            map.from(connectionNameStrategy::getIfUnique).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setConnectionNameStrategy(arg_0));
            return factory;
        }

        private RabbitConnectionFactoryBean getRabbitConnectionFactoryBean(RabbitProperties properties) throws Exception {
            PropertyMapper map = PropertyMapper.get();
            RabbitConnectionFactoryBean factory = new RabbitConnectionFactoryBean();
            map.from(properties::determineHost).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setHost(arg_0));
            map.from(properties::determinePort).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPort(arg_0));
            map.from(properties::determineUsername).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setUsername(arg_0));
            map.from(properties::determinePassword).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPassword(arg_0));
            map.from(properties::determineVirtualHost).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setVirtualHost(arg_0));
            map.from(properties::getRequestedHeartbeat).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setRequestedHeartbeat(arg_0));
            RabbitProperties.Ssl ssl = properties.getSsl();
            if (ssl.isEnabled()) {
                factory.setUseSSL(true);
                map.from(ssl::getAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setSslAlgorithm(arg_0));
                map.from(ssl::getKeyStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStoreType(arg_0));
                map.from(ssl::getKeyStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStore(arg_0));
                map.from(ssl::getKeyStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStorePassphrase(arg_0));
                map.from(ssl::getTrustStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStoreType(arg_0));
                map.from(ssl::getTrustStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStore(arg_0));
                map.from(ssl::getTrustStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStorePassphrase(arg_0));
                map.from(ssl::isValidateServerCertificate).to(validate -> factory.setSkipServerCertificateValidation(validate == false));
                map.from(ssl::getVerifyHostname).when(Objects::nonNull).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setEnableHostnameVerification(arg_0));
                if (ssl.getVerifyHostname() == null && CAN_ENABLE_HOSTNAME_VERIFICATION) {
                    factory.setEnableHostnameVerification(true);
                }
            }
            map.from(properties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setConnectionTimeout(arg_0));
            factory.afterPropertiesSet();
            return factory;
        }
    }
}

