/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBufUtil;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RSemaphore;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.StringCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RedissonBaseAdder<T extends Number>
extends RedissonExpirable {
    private static final Logger log = LoggerFactory.getLogger(RedissonBaseAdder.class);
    private static final String CLEAR_MSG = "0";
    private static final String SUM_MSG = "1";
    private final RedissonClient redisson;
    private final RTopic topic;
    private final int listenerId;

    public RedissonBaseAdder(CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(connectionManager, name);
        this.topic = redisson.getTopic(RedissonBaseAdder.suffixName(this.getName(), "topic"), StringCodec.INSTANCE);
        this.redisson = redisson;
        this.listenerId = this.topic.addListener(String.class, (channel, msg) -> {
            String[] parts = msg.split(":");
            String id = parts[1];
            RSemaphore semaphore = this.getSemaphore(id);
            if (parts[0].equals(SUM_MSG)) {
                RFuture<T> addAndGetFuture = this.addAndGetAsync(id);
                addAndGetFuture.onComplete((res, e) -> {
                    if (e != null) {
                        log.error("Can't increase sum", (Throwable)e);
                        return;
                    }
                    semaphore.releaseAsync().onComplete((r, ex) -> {
                        if (ex != null) {
                            log.error("Can't release semaphore", (Throwable)ex);
                        }
                    });
                });
            }
            if (parts[0].equals(CLEAR_MSG)) {
                this.doReset();
                semaphore.releaseAsync().onComplete((res, e) -> {
                    if (e != null) {
                        log.error("Can't release semaphore", (Throwable)e);
                    }
                });
            }
        });
    }

    protected abstract void doReset();

    private String generateId() {
        byte[] id = new byte[16];
        ThreadLocalRandom.current().nextBytes(id);
        return ByteBufUtil.hexDump(id);
    }

    public void reset() {
        this.get(this.resetAsync());
    }

    public void reset(long timeout, TimeUnit timeUnit) {
        this.get(this.resetAsync(timeout, timeUnit));
    }

    public RFuture<T> sumAsync() {
        RedissonPromise result = new RedissonPromise();
        String id = this.generateId();
        RFuture<Long> future = this.topic.publishAsync("1:" + id);
        RSemaphore semaphore = this.getSemaphore(id);
        future.onComplete(new SumListener(id, semaphore, result));
        return result;
    }

    private RSemaphore getSemaphore(String id) {
        return this.redisson.getSemaphore(RedissonBaseAdder.suffixName(this.getName(), id + ":semaphore"));
    }

    protected String getCounterName(String id) {
        return RedissonBaseAdder.suffixName(this.getName(), id + ":counter");
    }

    public RFuture<T> sumAsync(final long timeout, final TimeUnit timeUnit) {
        RedissonPromise result = new RedissonPromise();
        String id = this.generateId();
        RFuture<Long> future = this.topic.publishAsync("1:" + id);
        final RSemaphore semaphore = this.getSemaphore(id);
        future.onComplete(new SumListener(id, semaphore, result){

            @Override
            protected RFuture<Void> acquireAsync(int value) {
                return RedissonBaseAdder.this.tryAcquire(semaphore, timeout, timeUnit, value);
            }
        });
        return result;
    }

    protected RFuture<Void> tryAcquire(RSemaphore semaphore, long timeout, TimeUnit timeUnit, int value) {
        RedissonPromise<Void> acquireResult = new RedissonPromise<Void>();
        semaphore.tryAcquireAsync(value, timeout, timeUnit).onComplete((res, e) -> {
            if (e != null) {
                acquireResult.tryFailure((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                acquireResult.trySuccess(null);
            } else {
                acquireResult.tryFailure(new TimeoutException());
            }
        });
        return acquireResult;
    }

    public RFuture<Void> resetAsync() {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        String id = this.generateId();
        RFuture<Long> future = this.topic.publishAsync("0:" + id);
        RSemaphore semaphore = this.getSemaphore(id);
        future.onComplete(new ResetListener(semaphore, result));
        return result;
    }

    public RFuture<Void> resetAsync(final long timeout, final TimeUnit timeUnit) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        String id = this.generateId();
        RFuture<Long> future = this.topic.publishAsync("0:" + id);
        final RSemaphore semaphore = this.getSemaphore(id);
        future.onComplete(new ResetListener(semaphore, result){

            @Override
            protected RFuture<Void> acquireAsync(int value) {
                return RedissonBaseAdder.this.tryAcquire(semaphore, timeout, timeUnit, value);
            }
        });
        return result;
    }

    public void destroy() {
        this.topic.removeListener(this.listenerId);
    }

    protected abstract RFuture<T> addAndGetAsync(String var1);

    protected abstract RFuture<T> getAndDeleteAsync(String var1);

    private class SumListener
    implements BiConsumer<Long, Throwable> {
        private final RPromise<T> result;
        private final RSemaphore semaphore;
        private final String id;

        SumListener(String id, RSemaphore semaphore, RPromise<T> result) {
            this.result = result;
            this.semaphore = semaphore;
            this.id = id;
        }

        @Override
        public void accept(Long t, Throwable u) {
            if (u != null) {
                this.result.tryFailure(u);
                return;
            }
            this.acquireAsync(t.intValue()).onComplete((r, e) -> {
                if (e != null) {
                    this.result.tryFailure((Throwable)e);
                    return;
                }
                RFuture valueFuture = RedissonBaseAdder.this.getAndDeleteAsync(this.id);
                valueFuture.onComplete((res, ex) -> {
                    if (ex != null) {
                        this.result.tryFailure((Throwable)ex);
                        return;
                    }
                    this.semaphore.deleteAsync().onComplete((re, exc) -> {
                        if (exc != null) {
                            this.result.tryFailure((Throwable)exc);
                            return;
                        }
                        this.result.trySuccess((Number)res);
                    });
                });
            });
        }

        protected RFuture<Void> acquireAsync(int value) {
            return this.semaphore.acquireAsync(value);
        }
    }

    private class ResetListener
    implements BiConsumer<Long, Throwable> {
        private final RPromise<Void> result;
        private final RSemaphore semaphore;

        ResetListener(RSemaphore semaphore, RPromise<Void> result) {
            this.result = result;
            this.semaphore = semaphore;
        }

        @Override
        public void accept(Long t, Throwable u) {
            if (u != null) {
                this.result.tryFailure(u);
                return;
            }
            this.acquireAsync(t.intValue()).onComplete((res, e) -> {
                if (e != null) {
                    this.result.tryFailure((Throwable)e);
                    return;
                }
                this.semaphore.deleteAsync().onComplete((re, exc) -> {
                    if (exc != null) {
                        this.result.tryFailure((Throwable)exc);
                        return;
                    }
                    this.result.trySuccess((Void)res);
                });
            });
        }

        protected RFuture<Void> acquireAsync(int value) {
            return this.semaphore.acquireAsync(value);
        }
    }
}

