/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.text.TextUtils;
import com.hpplay.component.common.utils.DeviceProperties;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.Feature;
import java.util.Map;

public class Adapter {
    private static final String TAG = "Adapter";

    public static boolean useLowFrameRate() {
        try {
            if ("M2010J19SC".equals(DeviceProperties.getModel())) {
                SourceLog.w(TAG, "useLowFrameRate for M2010J19SC");
                return true;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return false;
    }

    public static int adjustFrame(int n2) {
        if (Adapter.useLowFrameRate()) {
            return 30;
        }
        if (Feature.isPico()) {
            return 60;
        }
        int n3 = Preference.getInstance().get("key_mirror_fps", 0);
        if (n3 > 0) {
            return n3;
        }
        return n2;
    }

    public static int adjustBitRate(int n2) {
        if (Feature.isPico()) {
            return 0xA00000;
        }
        return n2;
    }

    public static boolean delayStop(OutParameter outParameter) {
        try {
            String string = outParameter.currentBrowserInfo.getName();
            Map<String, String> map = outParameter.currentBrowserInfo.getExtras();
            String string2 = map.get("dlna_mode_name");
            String string3 = map.get("manufacturer");
            if (!TextUtils.isEmpty((CharSequence)string) && string.contains("\u7231\u6295\u5c4f") && "Media Renderer".equals(string2) && "DLNA".equals(string3)) {
                return true;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return false;
    }
}

