/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.protocol.LelinkPushBridge;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.HpplayUtil;
import java.net.URLDecoder;

public class DLNABridge
extends LelinkPushBridge {
    public DLNABridge(Context context, OutParameter outParameter) {
        super(context, outParameter);
        TAG = "DLNABridge";
    }

    @Override
    public void play(String string) {
        if (this.mPushController == null) {
            SourceLog.w(TAG, "play ignore");
            return;
        }
        BrowserInfo browserInfo = this.mPlayInfo.currentBrowserInfo;
        if (browserInfo == null) {
            SourceLog.w(TAG, "play ignore, invalid browser info");
            return;
        }
        this.isCallPrepared = false;
        this.mDuration = this.mPlayInfo.duration;
        String string2 = "";
        if (this.mPlayInfo.serviceInfo != null) {
            string2 = this.mPlayInfo.serviceInfo.getName();
        }
        SourceLog.i(TAG, "play " + this.mPlayInfo.getPlayUrl() + " to " + string2 + "/" + this);
        ParamsMap paramsMap = ParamsMap.create();
        paramsMap.putParam("uid", browserInfo.getUid());
        paramsMap.putParam("uri", this.mPlayInfo.urlID);
        paramsMap.putParam("mediatype", this.mPlayInfo.mimeType + "");
        paramsMap.putParam("protocol_type", this.mPlayInfo.protocol + "");
        paramsMap.putParam("start_postion", this.mPlayInfo.startPosition);
        paramsMap.putParam("ip", browserInfo.getIp());
        paramsMap.putParam("location_uri", browserInfo.getExtras().get("dlna_location"));
        if (this.mPlayInfo.mediaAssetBean != null && !TextUtils.isEmpty((CharSequence)this.mPlayInfo.mediaAssetBean.getMetaData())) {
            paramsMap.put("dlna_meta_data", this.mPlayInfo.mediaAssetBean.getMetaData());
        }
        paramsMap.putParam("sessionId", this.mPlayInfo.session);
        paramsMap.putParam("connectSessionId", this.mPlayInfo.connectSession);
        if (this.mPlayInfo.mediaAssetBean != null && !this.mPlayInfo.mediaAssetBean.isEmpty()) {
            try {
                if (!TextUtils.isEmpty((CharSequence)this.mPlayInfo.mediaAssetBean.getName())) {
                    paramsMap.putParam("mediaAssetName", URLDecoder.decode(this.mPlayInfo.mediaAssetBean.getName(), "utf-8"));
                }
                if (!TextUtils.isEmpty((CharSequence)this.mPlayInfo.mediaAssetBean.getAlbum())) {
                    paramsMap.putParam("dlna_album", URLDecoder.decode(this.mPlayInfo.mediaAssetBean.getAlbum(), "utf-8"));
                }
                if (!TextUtils.isEmpty((CharSequence)this.mPlayInfo.mediaAssetBean.getAlbumArtURI())) {
                    paramsMap.putParam("dlna_album_url", this.mPlayInfo.mediaAssetBean.getAlbumArtURI());
                }
                if (!TextUtils.isEmpty((CharSequence)this.mPlayInfo.mediaAssetBean.getActor())) {
                    paramsMap.putParam("dlna_artist", URLDecoder.decode(this.mPlayInfo.mediaAssetBean.getActor(), "utf-8"));
                }
                if (!TextUtils.isEmpty((CharSequence)this.mPlayInfo.mediaAssetBean.getDirector())) {
                    paramsMap.putParam("dlna_creator", URLDecoder.decode(this.mPlayInfo.mediaAssetBean.getDirector(), "utf-8"));
                }
                if (!TextUtils.isEmpty((CharSequence)this.mPlayInfo.mediaAssetBean.getId())) {
                    paramsMap.putParam("playid", this.mPlayInfo.mediaAssetBean.getId());
                }
                if (!TextUtils.isEmpty((CharSequence)this.mPlayInfo.mediaAssetBean.getResolution())) {
                    paramsMap.putParam("dlna_resolution", this.mPlayInfo.mediaAssetBean.getResolution());
                }
                paramsMap.putParam("dlna_size", String.valueOf(this.mPlayInfo.mediaAssetBean.getSize()));
                paramsMap.putParam("dlna_duration", String.valueOf(this.mPlayInfo.mediaAssetBean.getDuration()));
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            paramsMap.putParam("dlna_duration", HpplayUtil.secToTime(this.mPlayInfo.mediaAssetBean.getDuration()));
            paramsMap.putParam("dlna_size", this.mPlayInfo.mediaAssetBean.getSize());
            paramsMap.putParam("dlna_resolution", this.mPlayInfo.mediaAssetBean.getResolution());
        }
        SourceLog.i(TAG, "play " + paramsMap.toString());
        this.mPushController.DLNARetryHttp(this.mPlayInfo.retryDLNAHttp);
        this.mPushController.push(this.mPlayInfo.getPlayUrl(), paramsMap);
        this.isJGTP = this.isJGTP();
    }

    private boolean isJGTP() {
        LelinkServiceInfo lelinkServiceInfo = this.mPlayInfo.serviceInfo;
        if (lelinkServiceInfo == null) {
            return false;
        }
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 3);
        if (browserInfo == null) {
            return false;
        }
        String string = browserInfo.getExtras().get("dlna_mode_name");
        String string2 = browserInfo.getExtras().get("manufacturer");
        return "QQLiveTV Render".equalsIgnoreCase(string) && string2.contains("\u6781\u5149");
    }
}

