/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.text.TextUtils;
import com.hpplay.sdk.source.browse.api.IAPICallbackListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.KeepAliveUtitls;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class OnlineCheckThread
extends Thread {
    private static final String TAG = "OnlineCheckThread";
    private List<LelinkServiceInfo> mLelinkServiceInfos;
    private List<LelinkServiceInfo> mCopyLelinkServiceInfo = new CopyOnWriteArrayList<LelinkServiceInfo>();
    private IAPICallbackListener mIapiCallbackListener;
    private boolean isCompletion;

    public OnlineCheckThread(IAPICallbackListener iAPICallbackListener, List<LelinkServiceInfo> list) {
        this.setName(TAG);
        this.mLelinkServiceInfos = list;
        this.mIapiCallbackListener = iAPICallbackListener;
    }

    public boolean isCompletion() {
        return this.isCompletion;
    }

    @Override
    public void run() {
        super.run();
        try {
            this.isCompletion = false;
            this.mCopyLelinkServiceInfo.clear();
            this.mCopyLelinkServiceInfo.addAll(this.mLelinkServiceInfos);
            SourceLog.i(TAG, " init info size  : " + this.mCopyLelinkServiceInfo.size());
            if (this.mCopyLelinkServiceInfo.size() > 0) {
                for (LelinkServiceInfo lelinkServiceInfo : this.mCopyLelinkServiceInfo) {
                    try {
                        Map<Integer, BrowserInfo> map;
                        if (lelinkServiceInfo == null || (map = lelinkServiceInfo.getBrowserInfos()) == null) continue;
                        Collection<BrowserInfo> collection = map.values();
                        OnlineCheckThread.doCheck(collection);
                    }
                    catch (Exception exception) {
                        SourceLog.w(TAG, exception);
                    }
                }
            }
            if (this.mIapiCallbackListener != null) {
                SourceLog.i(TAG, " call back size : " + this.mCopyLelinkServiceInfo.size());
                this.mIapiCallbackListener.onResult(65539, this.mCopyLelinkServiceInfo);
                this.isCompletion = true;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public static void doCheck(Collection<BrowserInfo> collection) {
        List<BrowserInfo> list;
        CharSequence charSequence;
        List<BrowserInfo> list2 = OnlineCheckThread.filterBrowserInfosByConnectType(0, collection);
        if (null != list2 && !list2.isEmpty()) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("doCheck tcpCheck:").append("\r\n");
            for (BrowserInfo browserInfo : list2) {
                if (TextUtils.isEmpty((CharSequence)browserInfo.getIp())) continue;
                boolean bl = KeepAliveUtitls.tcpCheckTvState(browserInfo.getName(), browserInfo.getIp(), browserInfo.getPort());
                ((StringBuilder)charSequence).append("name:").append(browserInfo.getName()).append(" alive state:").append(bl).append("\r\n");
                browserInfo.setLocalWifi(bl);
                browserInfo.setOnLine(bl);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    SourceLog.w(TAG, interruptedException);
                    break;
                }
            }
            SourceLog.i(TAG, ((StringBuilder)charSequence).toString());
        }
        if (null != (list = OnlineCheckThread.filterBrowserInfosByConnectType(1, collection)) && !list.isEmpty()) {
            charSequence = KeepAliveUtitls.httpPostCheckTvState(list);
            SourceLog.i(TAG, "doCheck cloud:" + (String)charSequence);
        }
    }

    private static List<BrowserInfo> filterBrowserInfosByConnectType(int n2, Collection<BrowserInfo> collection) {
        if (null == collection || collection.isEmpty()) {
            SourceLog.i(TAG, "filterBrowserInfosByConnectType is empty");
            return null;
        }
        SourceLog.i(TAG, "filterBrowserInfosByConnectType");
        ArrayList<BrowserInfo> arrayList = new ArrayList<BrowserInfo>();
        for (BrowserInfo browserInfo : collection) {
            if (browserInfo.getConnectionType() != n2) continue;
            arrayList.add(browserInfo);
        }
        return arrayList;
    }

    public void release() {
        this.mIapiCallbackListener = null;
        this.interrupt();
    }
}

