/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.ClientSubnetOption;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.GenericEDNSOption;
import com.hpplay.sdk.source.mdns.xbill.dns.Mnemonic;
import com.hpplay.sdk.source.mdns.xbill.dns.NSIDOption;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import java.util.Arrays;

public abstract class EDNSOption {
    private final int code;

    public EDNSOption(int n2) {
        this.code = Record.checkU16("code", n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append(Code.string(this.code));
        stringBuffer.append(": ");
        stringBuffer.append(this.optionToString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public int getCode() {
        return this.code;
    }

    byte[] getData() {
        DNSOutput dNSOutput = new DNSOutput();
        this.optionToWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    abstract void optionFromWire(DNSInput var1);

    static EDNSOption fromWire(DNSInput dNSInput) {
        EDNSOption eDNSOption;
        int n2 = dNSInput.readU16();
        int n3 = dNSInput.readU16();
        if (dNSInput.remaining() < n3) {
            throw new Exception("truncated option");
        }
        int n4 = dNSInput.saveActive();
        dNSInput.setActive(n3);
        switch (n2) {
            case 3: {
                eDNSOption = new NSIDOption();
                break;
            }
            case 8: {
                eDNSOption = new ClientSubnetOption();
                break;
            }
            default: {
                eDNSOption = new GenericEDNSOption(n2);
            }
        }
        eDNSOption.optionFromWire(dNSInput);
        dNSInput.restoreActive(n4);
        return eDNSOption;
    }

    public static EDNSOption fromWire(byte[] byArray) {
        return EDNSOption.fromWire(new DNSInput(byArray));
    }

    abstract void optionToWire(DNSOutput var1);

    void toWire(DNSOutput dNSOutput) {
        dNSOutput.writeU16(this.code);
        int n2 = dNSOutput.current();
        dNSOutput.writeU16(0);
        this.optionToWire(dNSOutput);
        int n3 = dNSOutput.current() - n2 - 2;
        dNSOutput.writeU16At(n3, n2);
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EDNSOption)) {
            return false;
        }
        EDNSOption eDNSOption = (EDNSOption)object;
        if (this.code != eDNSOption.code) {
            return false;
        }
        return Arrays.equals(this.getData(), eDNSOption.getData());
    }

    public int hashCode() {
        byte[] byArray = this.getData();
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 += (n2 << 3) + (byArray[i2] & 0xFF);
        }
        return n2;
    }

    abstract String optionToString();

    public static class Code {
        public static final int NSID = 3;
        public static final int CLIENT_SUBNET = 8;
        private static Mnemonic codes = new Mnemonic("EDNS Option Codes", 2);

        public static String string(int n2) {
            return codes.getText(n2);
        }

        public static int value(String string) {
            return codes.getValue(string);
        }

        private Code() {
        }

        static {
            codes.setMaximum(65535);
            codes.setPrefix("CODE");
            codes.setNumericAllowed(true);
            codes.add(3, "NSID");
            codes.add(8, "CLIENT_SUBNET");
        }
    }
}

