/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.engine.cache.MemoryCache;
import com.hpplay.glide.load.engine.prefill.PreFillQueue;
import com.hpplay.glide.load.engine.prefill.PreFillType;
import com.hpplay.glide.load.resource.bitmap.BitmapResource;
import com.hpplay.glide.util.Util;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

final class BitmapPreFillRunner
implements Runnable {
    private static final String TAG = "PreFillRunner";
    private static final Clock DEFAULT_CLOCK = new Clock();
    static final long MAX_DURATION_MS = 32L;
    static final long INITIAL_BACKOFF_MS = 40L;
    static final int BACKOFF_RATIO = 4;
    static final long MAX_BACKOFF_MS = TimeUnit.SECONDS.toMillis(1L);
    private final BitmapPool bitmapPool;
    private final MemoryCache memoryCache;
    private final PreFillQueue toPrefill;
    private final Clock clock;
    private final Set<PreFillType> seenTypes = new HashSet<PreFillType>();
    private final Handler handler;
    private long currentDelay = 40L;
    private boolean isCancelled;

    public BitmapPreFillRunner(BitmapPool bitmapPool, MemoryCache memoryCache, PreFillQueue preFillQueue) {
        this(bitmapPool, memoryCache, preFillQueue, DEFAULT_CLOCK, new Handler(Looper.getMainLooper()));
    }

    BitmapPreFillRunner(BitmapPool bitmapPool, MemoryCache memoryCache, PreFillQueue preFillQueue, Clock clock, Handler handler) {
        this.bitmapPool = bitmapPool;
        this.memoryCache = memoryCache;
        this.toPrefill = preFillQueue;
        this.clock = clock;
        this.handler = handler;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    private boolean allocate() {
        long l2 = this.clock.now();
        while (!this.toPrefill.isEmpty() && !this.isGcDetected(l2)) {
            PreFillType preFillType = this.toPrefill.remove();
            Bitmap bitmap = Bitmap.createBitmap((int)preFillType.getWidth(), (int)preFillType.getHeight(), (Bitmap.Config)preFillType.getConfig());
            if (this.getFreeMemoryCacheBytes() >= Util.getBitmapByteSize(bitmap)) {
                this.memoryCache.put(new UniqueKey(), BitmapResource.obtain(bitmap, this.bitmapPool));
            } else {
                this.addToBitmapPool(preFillType, bitmap);
            }
            if (!Log.isLoggable((String)TAG, (int)3)) continue;
            Log.d((String)TAG, (String)("allocated [" + preFillType.getWidth() + "x" + preFillType.getHeight() + "] " + preFillType.getConfig() + " size: " + Util.getBitmapByteSize(bitmap)));
        }
        return !this.isCancelled && !this.toPrefill.isEmpty();
    }

    private boolean isGcDetected(long l2) {
        return this.clock.now() - l2 >= 32L;
    }

    private int getFreeMemoryCacheBytes() {
        return this.memoryCache.getMaxSize() - this.memoryCache.getCurrentSize();
    }

    private void addToBitmapPool(PreFillType preFillType, Bitmap bitmap) {
        Bitmap bitmap2;
        if (this.seenTypes.add(preFillType) && (bitmap2 = this.bitmapPool.get(preFillType.getWidth(), preFillType.getHeight(), preFillType.getConfig())) != null) {
            this.bitmapPool.put(bitmap2);
        }
        this.bitmapPool.put(bitmap);
    }

    @Override
    public void run() {
        if (this.allocate()) {
            this.handler.postDelayed((Runnable)this, this.getNextDelay());
        }
    }

    private long getNextDelay() {
        long l2 = this.currentDelay;
        this.currentDelay = Math.min(this.currentDelay * 4L, MAX_BACKOFF_MS);
        return l2;
    }

    static class Clock {
        Clock() {
        }

        public long now() {
            return SystemClock.currentThreadTimeMillis();
        }
    }

    private static class UniqueKey
    implements Key {
        private UniqueKey() {
        }

        @Override
        public void updateDiskCacheKey(MessageDigest messageDigest) {
        }
    }
}

