/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.gifdecoder;

import android.util.Log;
import com.hpplay.glide.gifdecoder.GifFrame;
import com.hpplay.glide.gifdecoder.GifHeader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GifHeaderParser {
    public static final String TAG = "GifHeaderParser";
    static final int MIN_FRAME_DELAY = 3;
    static final int DEFAULT_FRAME_DELAY = 10;
    private static final int MAX_BLOCK_SIZE = 256;
    private final byte[] block = new byte[256];
    private ByteBuffer rawData;
    private GifHeader header;
    private int blockSize = 0;

    public GifHeaderParser setData(byte[] byArray) {
        this.reset();
        if (byArray != null) {
            this.rawData = ByteBuffer.wrap(byArray);
            this.rawData.rewind();
            this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.rawData = null;
            this.header.status = 2;
        }
        return this;
    }

    public void clear() {
        this.rawData = null;
        this.header = null;
    }

    private void reset() {
        this.rawData = null;
        Arrays.fill(this.block, (byte)0);
        this.header = new GifHeader();
        this.blockSize = 0;
    }

    public GifHeader parseHeader() {
        if (this.rawData == null) {
            throw new IllegalStateException("You must call setData() before parseHeader()");
        }
        if (this.err()) {
            return this.header;
        }
        this.readHeader();
        if (!this.err()) {
            this.readContents();
            if (this.header.frameCount < 0) {
                this.header.status = 1;
            }
        }
        return this.header;
    }

    private void readContents() {
        boolean bl = false;
        block11: while (!bl && !this.err()) {
            int n2 = this.read();
            switch (n2) {
                case 44: {
                    if (this.header.currentFrame == null) {
                        this.header.currentFrame = new GifFrame();
                    }
                    this.readBitmap();
                    continue block11;
                }
                case 33: {
                    n2 = this.read();
                    switch (n2) {
                        case 249: {
                            this.header.currentFrame = new GifFrame();
                            this.readGraphicControlExt();
                            continue block11;
                        }
                        case 255: {
                            this.readBlock();
                            String string = "";
                            for (int i2 = 0; i2 < 11; ++i2) {
                                string = string + (char)this.block[i2];
                            }
                            if (string.equals("NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block11;
                            }
                            this.skip();
                            continue block11;
                        }
                        case 254: {
                            this.skip();
                            continue block11;
                        }
                        case 1: {
                            this.skip();
                            continue block11;
                        }
                    }
                    this.skip();
                    continue block11;
                }
                case 59: {
                    bl = true;
                    continue block11;
                }
            }
            this.header.status = 1;
        }
    }

    private void readGraphicControlExt() {
        this.read();
        int n2 = this.read();
        this.header.currentFrame.dispose = (n2 & 0x1C) >> 2;
        if (this.header.currentFrame.dispose == 0) {
            this.header.currentFrame.dispose = 1;
        }
        this.header.currentFrame.transparency = (n2 & 1) != 0;
        int n3 = this.readShort();
        if (n3 < 3) {
            n3 = 10;
        }
        this.header.currentFrame.delay = n3 * 10;
        this.header.currentFrame.transIndex = this.read();
        this.read();
    }

    private void readBitmap() {
        this.header.currentFrame.ix = this.readShort();
        this.header.currentFrame.iy = this.readShort();
        this.header.currentFrame.iw = this.readShort();
        this.header.currentFrame.ih = this.readShort();
        int n2 = this.read();
        boolean bl = (n2 & 0x80) != 0;
        int n3 = (int)Math.pow(2.0, (n2 & 7) + 1);
        this.header.currentFrame.interlace = (n2 & 0x40) != 0;
        this.header.currentFrame.lct = (int[])(bl ? this.readColorTable(n3) : null);
        this.header.currentFrame.bufferFrameStart = this.rawData.position();
        this.skipImageData();
        if (this.err()) {
            return;
        }
        ++this.header.frameCount;
        this.header.frames.add(this.header.currentFrame);
    }

    private void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int n2 = this.block[1] & 0xFF;
            int n3 = this.block[2] & 0xFF;
            this.header.loopCount = n3 << 8 | n2;
        } while (this.blockSize > 0 && !this.err());
    }

    private void readHeader() {
        String string = "";
        for (int i2 = 0; i2 < 6; ++i2) {
            string = string + (char)this.read();
        }
        if (!string.startsWith("GIF")) {
            this.header.status = 1;
            return;
        }
        this.readLSD();
        if (this.header.gctFlag && !this.err()) {
            this.header.gct = this.readColorTable(this.header.gctSize);
            this.header.bgColor = this.header.gct[this.header.bgIndex];
        }
    }

    private void readLSD() {
        this.header.width = this.readShort();
        this.header.height = this.readShort();
        int n2 = this.read();
        this.header.gctFlag = (n2 & 0x80) != 0;
        this.header.gctSize = 2 << (n2 & 7);
        this.header.bgIndex = this.read();
        this.header.pixelAspect = this.read();
    }

    private int[] readColorTable(int n2) {
        int n3 = 3 * n2;
        int[] nArray = null;
        byte[] byArray = new byte[n3];
        try {
            this.rawData.get(byArray);
            nArray = new int[256];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n2) {
                int n6 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                nArray[n4++] = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Format Error Reading Color Table", (Throwable)bufferUnderflowException);
            }
            this.header.status = 1;
        }
        return nArray;
    }

    private void skipImageData() {
        this.read();
        this.skip();
    }

    private void skip() {
        int n2;
        do {
            n2 = this.read();
            this.rawData.position(this.rawData.position() + n2);
        } while (n2 > 0);
    }

    private int readBlock() {
        int n2;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            int n3 = 0;
            try {
                for (n2 = 0; n2 < this.blockSize; n2 += n3) {
                    n3 = this.blockSize - n2;
                    this.rawData.get(this.block, n2, n3);
                }
            }
            catch (Exception exception) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("Error Reading Block n: " + n2 + " count: " + n3 + " blockSize: " + this.blockSize), (Throwable)exception);
                }
                this.header.status = 1;
            }
        }
        return n2;
    }

    private int read() {
        int n2 = 0;
        try {
            n2 = this.rawData.get() & 0xFF;
        }
        catch (Exception exception) {
            this.header.status = 1;
        }
        return n2;
    }

    private int readShort() {
        return this.rawData.getShort();
    }

    private boolean err() {
        return this.header.status != 0;
    }
}

