/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.gifdecoder;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.hpplay.glide.gifdecoder.GifFrame;
import com.hpplay.glide.gifdecoder.GifHeader;
import com.hpplay.glide.gifdecoder.GifHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GifDecoder {
    private static final String TAG = GifDecoder.class.getSimpleName();
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    public static final int STATUS_PARTIAL_DECODE = 3;
    private static final int MAX_STACK_SIZE = 4096;
    private static final int DISPOSAL_UNSPECIFIED = 0;
    private static final int DISPOSAL_NONE = 1;
    private static final int DISPOSAL_BACKGROUND = 2;
    private static final int DISPOSAL_PREVIOUS = 3;
    private static final int NULL_CODE = -1;
    private static final int INITIAL_FRAME_POINTER = -1;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private int[] act;
    private ByteBuffer rawData;
    private final byte[] block = new byte[256];
    private GifHeaderParser parser;
    private short[] prefix;
    private byte[] suffix;
    private byte[] pixelStack;
    private byte[] mainPixels;
    private int[] mainScratch;
    private int framePointer;
    private byte[] data;
    private GifHeader header;
    private BitmapProvider bitmapProvider;
    private Bitmap previousImage;
    private boolean savePrevious;
    private int status;

    public GifDecoder(BitmapProvider bitmapProvider) {
        this.bitmapProvider = bitmapProvider;
        this.header = new GifHeader();
    }

    public int getWidth() {
        return this.header.width;
    }

    public int getHeight() {
        return this.header.height;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getStatus() {
        return this.status;
    }

    public void advance() {
        this.framePointer = (this.framePointer + 1) % this.header.frameCount;
    }

    public int getDelay(int n2) {
        int n3 = -1;
        if (n2 >= 0 && n2 < this.header.frameCount) {
            n3 = this.header.frames.get((int)n2).delay;
        }
        return n3;
    }

    public int getNextDelay() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            return -1;
        }
        return this.getDelay(this.framePointer);
    }

    public int getFrameCount() {
        return this.header.frameCount;
    }

    public int getCurrentFrameIndex() {
        return this.framePointer;
    }

    public void resetFrameIndex() {
        this.framePointer = -1;
    }

    public int getLoopCount() {
        return this.header.loopCount;
    }

    public synchronized Bitmap getNextFrame() {
        if (this.header.frameCount <= 0 || this.framePointer < 0) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("unable to decode frame, frameCount=" + this.header.frameCount + " framePointer=" + this.framePointer));
            }
            this.status = 1;
        }
        if (this.status == 1 || this.status == 2) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Unable to decode frame, status=" + this.status));
            }
            return null;
        }
        this.status = 0;
        GifFrame gifFrame = this.header.frames.get(this.framePointer);
        GifFrame gifFrame2 = null;
        int n2 = this.framePointer - 1;
        if (n2 >= 0) {
            gifFrame2 = this.header.frames.get(n2);
        }
        if (gifFrame.lct == null) {
            this.act = this.header.gct;
        } else {
            this.act = gifFrame.lct;
            if (this.header.bgIndex == gifFrame.transIndex) {
                this.header.bgColor = 0;
            }
        }
        int n3 = 0;
        if (gifFrame.transparency) {
            n3 = this.act[gifFrame.transIndex];
            this.act[gifFrame.transIndex] = 0;
        }
        if (this.act == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"No Valid Color Table");
            }
            this.status = 1;
            return null;
        }
        Bitmap bitmap = this.setPixels(gifFrame, gifFrame2);
        if (gifFrame.transparency) {
            this.act[gifFrame.transIndex] = n3;
        }
        return bitmap;
    }

    public int read(InputStream inputStream, int n2) {
        if (inputStream != null) {
            try {
                int n3;
                int n4 = n2 > 0 ? n2 + 4096 : 16384;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n4);
                byte[] byArray = new byte[16384];
                while ((n3 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n3);
                }
                byteArrayOutputStream.flush();
                this.read(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)iOException);
            }
        } else {
            this.status = 2;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Log.w((String)TAG, (String)"Error closing stream", (Throwable)iOException);
        }
        return this.status;
    }

    public void clear() {
        this.header = null;
        this.data = null;
        this.mainPixels = null;
        this.mainScratch = null;
        if (this.previousImage != null) {
            this.bitmapProvider.release(this.previousImage);
        }
        this.previousImage = null;
        this.rawData = null;
    }

    public void setData(GifHeader gifHeader, byte[] byArray) {
        this.header = gifHeader;
        this.data = byArray;
        this.status = 0;
        this.framePointer = -1;
        this.rawData = ByteBuffer.wrap(byArray);
        this.rawData.rewind();
        this.rawData.order(ByteOrder.LITTLE_ENDIAN);
        this.savePrevious = false;
        for (GifFrame gifFrame : gifHeader.frames) {
            if (gifFrame.dispose != 3) continue;
            this.savePrevious = true;
            break;
        }
        this.mainPixels = new byte[gifHeader.width * gifHeader.height];
        this.mainScratch = new int[gifHeader.width * gifHeader.height];
    }

    private GifHeaderParser getHeaderParser() {
        if (this.parser == null) {
            this.parser = new GifHeaderParser();
        }
        return this.parser;
    }

    public int read(byte[] byArray) {
        this.data = byArray;
        this.header = this.getHeaderParser().setData(byArray).parseHeader();
        if (byArray != null) {
            this.rawData = ByteBuffer.wrap(byArray);
            this.rawData.rewind();
            this.rawData.order(ByteOrder.LITTLE_ENDIAN);
            this.mainPixels = new byte[this.header.width * this.header.height];
            this.mainScratch = new int[this.header.width * this.header.height];
            this.savePrevious = false;
            for (GifFrame gifFrame : this.header.frames) {
                if (gifFrame.dispose != 3) continue;
                this.savePrevious = true;
                break;
            }
        }
        return this.status;
    }

    private Bitmap setPixels(GifFrame gifFrame, GifFrame gifFrame2) {
        int n2;
        int n3 = this.header.width;
        int n4 = this.header.height;
        int[] nArray = this.mainScratch;
        if (gifFrame2 != null && gifFrame2.dispose > 0) {
            if (gifFrame2.dispose == 2) {
                n2 = 0;
                if (!gifFrame.transparency) {
                    n2 = this.header.bgColor;
                }
                Arrays.fill(nArray, n2);
            } else if (gifFrame2.dispose == 3 && this.previousImage != null) {
                this.previousImage.getPixels(nArray, 0, n3, 0, 0, n3, n4);
            }
        }
        this.decodeBitmapData(gifFrame);
        n2 = 1;
        int n5 = 8;
        int n6 = 0;
        for (int i2 = 0; i2 < gifFrame.ih; ++i2) {
            int n7 = i2;
            if (gifFrame.interlace) {
                if (n6 >= gifFrame.ih) {
                    switch (++n2) {
                        case 2: {
                            n6 = 4;
                            break;
                        }
                        case 3: {
                            n6 = 2;
                            n5 = 4;
                            break;
                        }
                        case 4: {
                            n6 = 1;
                            n5 = 2;
                            break;
                        }
                    }
                }
                n7 = n6;
                n6 += n5;
            }
            if ((n7 += gifFrame.iy) >= this.header.height) continue;
            int n8 = n7 * this.header.width;
            int n9 = n8 + gifFrame.ix;
            int n10 = n9 + gifFrame.iw;
            if (n8 + this.header.width < n10) {
                n10 = n8 + this.header.width;
            }
            int n11 = i2 * gifFrame.iw;
            while (n9 < n10) {
                int n12;
                int n13;
                if ((n13 = this.act[n12 = this.mainPixels[n11++] & 0xFF]) != 0) {
                    nArray[n9] = n13;
                }
                ++n9;
            }
        }
        if (this.savePrevious && (gifFrame.dispose == 0 || gifFrame.dispose == 1)) {
            if (this.previousImage == null) {
                this.previousImage = this.getNextBitmap();
            }
            this.previousImage.setPixels(nArray, 0, n3, 0, 0, n3, n4);
        }
        Bitmap bitmap = this.getNextBitmap();
        bitmap.setPixels(nArray, 0, n3, 0, 0, n3, n4);
        return bitmap;
    }

    private void decodeBitmapData(GifFrame gifFrame) {
        int n2;
        int n3;
        if (gifFrame != null) {
            this.rawData.position(gifFrame.bufferFrameStart);
        }
        int n4 = n3 = gifFrame == null ? this.header.width * this.header.height : gifFrame.iw * gifFrame.ih;
        if (this.mainPixels == null || this.mainPixels.length < n3) {
            this.mainPixels = new byte[n3];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n5 = this.read();
        int n6 = 1 << n5;
        int n7 = n6 + 1;
        int n8 = n6 + 2;
        int n9 = -1;
        int n10 = n5 + 1;
        int n11 = (1 << n10) - 1;
        for (n2 = 0; n2 < n6; ++n2) {
            this.prefix[n2] = 0;
            this.suffix[n2] = (byte)n2;
        }
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        block1: while (n19 < n3) {
            if (n16 == 0) {
                n16 = this.readBlock();
                if (n16 <= 0) {
                    this.status = 3;
                    break;
                }
                n12 = 0;
            }
            n18 += (this.block[n12] & 0xFF) << n17;
            n17 += 8;
            ++n12;
            --n16;
            while (n17 >= n10) {
                n2 = n18 & n11;
                n18 >>= n10;
                n17 -= n10;
                if (n2 == n6) {
                    n10 = n5 + 1;
                    n11 = (1 << n10) - 1;
                    n8 = n6 + 2;
                    n9 = -1;
                    continue;
                }
                if (n2 > n8) {
                    this.status = 3;
                    continue block1;
                }
                if (n2 == n7) continue block1;
                if (n9 == -1) {
                    this.pixelStack[n14++] = this.suffix[n2];
                    n9 = n2;
                    n15 = n2;
                    continue;
                }
                int n20 = n2;
                if (n2 >= n8) {
                    this.pixelStack[n14++] = (byte)n15;
                    n2 = n9;
                }
                while (n2 >= n6) {
                    this.pixelStack[n14++] = this.suffix[n2];
                    n2 = this.prefix[n2];
                }
                n15 = this.suffix[n2] & 0xFF;
                this.pixelStack[n14++] = (byte)n15;
                if (n8 < 4096) {
                    this.prefix[n8] = (short)n9;
                    this.suffix[n8] = (byte)n15;
                    if ((++n8 & n11) == 0 && n8 < 4096) {
                        ++n10;
                        n11 += n8;
                    }
                }
                n9 = n20;
                while (n14 > 0) {
                    this.mainPixels[n13++] = this.pixelStack[--n14];
                    ++n19;
                }
            }
        }
        for (n19 = n13; n19 < n3; ++n19) {
            this.mainPixels[n19] = 0;
        }
    }

    private int read() {
        int n2 = 0;
        try {
            n2 = this.rawData.get() & 0xFF;
        }
        catch (Exception exception) {
            this.status = 1;
        }
        return n2;
    }

    private int readBlock() {
        int n2;
        int n3 = this.read();
        if (n3 > 0) {
            try {
                int n4;
                for (n2 = 0; n2 < n3; n2 += n4) {
                    n4 = n3 - n2;
                    this.rawData.get(this.block, n2, n4);
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"Error Reading Block", (Throwable)exception);
                this.status = 1;
            }
        }
        return n2;
    }

    private Bitmap getNextBitmap() {
        Bitmap bitmap = this.bitmapProvider.obtain(this.header.width, this.header.height, BITMAP_CONFIG);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)this.header.width, (int)this.header.height, (Bitmap.Config)BITMAP_CONFIG);
        }
        GifDecoder.setAlpha(bitmap);
        return bitmap;
    }

    @TargetApi(value=12)
    private static void setAlpha(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            bitmap.setHasAlpha(true);
        }
    }

    public static interface BitmapProvider {
        public Bitmap obtain(int var1, int var2, Bitmap.Config var3);

        public void release(Bitmap var1);
    }
}

