/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.util;

import android.text.TextUtils;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.net.HostInterface;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;

public class OnlineCheckUtil {
    private static final int TCP_TIMEOUT = 3000;
    private static final String TAG = "OnlineCheckUtil";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tcpCheckTvState(String string, int n2) {
        boolean bl = false;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.setSoTimeout(3000);
            String string2 = OnlineCheckUtil.matchLocalIp(string);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                InetAddress inetAddress = InetAddress.getByName(string);
                InetAddress inetAddress2 = InetAddress.getByName(string2);
                socket.bind(new InetSocketAddress(inetAddress2, OnlineCheckUtil.getAvailablePort()));
                socket.connect(new InetSocketAddress(inetAddress, n2), 3000);
            } else {
                socket.connect(new InetSocketAddress(string, n2), 3000);
            }
            bl = true;
        }
        catch (Exception exception) {
            CLog.w(TAG, "local device : " + string.replace(".", "") + " is offline");
        }
        finally {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    CLog.w(TAG, iOException);
                }
            }
        }
        CLog.i(TAG, "  check dev state " + bl);
        return bl;
    }

    public static int getAvailablePort() {
        Random random = new Random();
        int n2 = 10090;
        try {
            for (int i2 = n2 = random.nextInt(10000) + 10000 + random.nextInt(100); i2 <= 65535; ++i2) {
                try {
                    new ServerSocket(i2).close();
                    CLog.i(TAG, "get availabel port " + i2);
                    return i2;
                }
                catch (IOException iOException) {
                    continue;
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return n2;
    }

    private static String matchLocalIp(String string) {
        String string2 = null;
        try {
            String string3 = string.substring(0, string.lastIndexOf("."));
            int n2 = HostInterface.getNHostAddresses();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string4 = HostInterface.getHostAddress(i2);
                if (string4.contains(string3)) {
                    string2 = string4;
                }
                CLog.i(TAG, "check local host ====> " + string4.replace(".", ""));
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return string2;
    }
}

