/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.net.HostInterface;
import com.hpplay.cybergarage.upnp.ControlPoint;
import com.hpplay.cybergarage.upnp.ssdp.SSDPNotifySocket;
import java.net.InetAddress;
import java.util.Vector;

public class SSDPNotifySocketList
extends Vector {
    private InetAddress[] binds = null;

    public SSDPNotifySocketList() {
    }

    public SSDPNotifySocketList(InetAddress[] inetAddressArray) {
        this.binds = inetAddressArray;
    }

    public SSDPNotifySocket getSSDPNotifySocket(int n2) {
        return (SSDPNotifySocket)this.get(n2);
    }

    public void setControlPoint(ControlPoint controlPoint) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                SSDPNotifySocket sSDPNotifySocket = this.getSSDPNotifySocket(i2);
                sSDPNotifySocket.setControlPoint(controlPoint);
                continue;
            }
            catch (Exception exception) {
                CLog.w("ssdpnotify", exception);
                break;
            }
        }
    }

    public boolean open() {
        int n2;
        String[] stringArray;
        InetAddress[] inetAddressArray = this.binds;
        if (inetAddressArray != null) {
            stringArray = new String[inetAddressArray.length];
            for (n2 = 0; n2 < inetAddressArray.length; ++n2) {
                stringArray[n2] = inetAddressArray[n2].getHostAddress();
            }
        } else {
            n2 = HostInterface.getNHostAddresses();
            stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = HostInterface.getHostAddress(i2);
            }
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] == null) continue;
            SSDPNotifySocket sSDPNotifySocket = new SSDPNotifySocket(stringArray[n2]);
            this.add(sSDPNotifySocket);
        }
        return true;
    }

    public void close() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                SSDPNotifySocket sSDPNotifySocket = this.getSSDPNotifySocket(i2);
                sSDPNotifySocket.close();
                continue;
            }
            catch (Exception exception) {
                CLog.w("ssdpnotify", exception);
                break;
            }
        }
        this.clear();
    }

    public void start() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                SSDPNotifySocket sSDPNotifySocket = this.getSSDPNotifySocket(i2);
                sSDPNotifySocket.start();
                continue;
            }
            catch (Exception exception) {
                CLog.w("ssdpnotify", exception);
                break;
            }
        }
    }

    public boolean isRuning() {
        try {
            if (this.size() > 0 && this.getSSDPNotifySocket(0) != null) {
                return this.getSSDPNotifySocket(0).isRuning();
            }
        }
        catch (Exception exception) {
            CLog.w("ssdpnotify", exception);
        }
        return false;
    }

    public void stop() {
        try {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                SSDPNotifySocket sSDPNotifySocket = this.getSSDPNotifySocket(i2);
                sSDPNotifySocket.stop();
            }
        }
        catch (Exception exception) {
            CLog.w("ssdpnotify", exception);
        }
    }
}

