/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacket;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class HTTPUSocket {
    private static final String TAG = "Cyber-HTTPUSocket";
    private DatagramSocket ssdpUniSock = null;
    private String localAddr = "";

    public DatagramSocket getDatagramSocket() {
        return this.ssdpUniSock;
    }

    public HTTPUSocket() {
        this.open();
    }

    public HTTPUSocket(String string, int n2) {
        this.open(string, n2);
    }

    public HTTPUSocket(int n2) {
        this.open(n2);
    }

    protected void finalize() {
        this.close();
    }

    public void setLocalAddress(String string) {
        this.localAddr = string;
    }

    public DatagramSocket getUDPSocket() {
        return this.ssdpUniSock;
    }

    public String getLocalAddress() {
        try {
            if (0 < this.localAddr.length()) {
                return this.localAddr;
            }
            return this.ssdpUniSock.getLocalAddress().getHostAddress();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return "127.0.0.1";
        }
    }

    public boolean open() {
        this.close();
        try {
            this.ssdpUniSock = new DatagramSocket();
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
        return true;
    }

    public boolean open(String string, int n2) {
        this.close();
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
            this.ssdpUniSock = new DatagramSocket(inetSocketAddress);
        }
        catch (BindException bindException) {
            CLog.d(TAG, null, bindException);
            throw bindException;
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
        this.setLocalAddress(string);
        return true;
    }

    public boolean open(int n2) {
        this.close();
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(n2);
            this.ssdpUniSock = new DatagramSocket(null);
            this.ssdpUniSock.setReuseAddress(true);
            this.ssdpUniSock.bind(inetSocketAddress);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean close() {
        if (this.ssdpUniSock == null) {
            return true;
        }
        try {
            this.ssdpUniSock.close();
            this.ssdpUniSock = null;
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
        return true;
    }

    public boolean post(String string, int n2, String string2) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            DatagramPacket datagramPacket = new DatagramPacket(string2.getBytes(), string2.length(), inetAddress, n2);
            this.ssdpUniSock.send(datagramPacket);
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
        return true;
    }

    public SSDPPacket receive() {
        byte[] byArray = new byte[1024];
        SSDPPacket sSDPPacket = new SSDPPacket(byArray, byArray.length);
        try {
            sSDPPacket.setLocalAddress(this.getLocalAddress());
            this.ssdpUniSock.receive(sSDPPacket.getDatagramPacket());
            sSDPPacket.setTimeStamp(System.currentTimeMillis());
            CLog.d(TAG, "========================>>>>>>>>>>>>>> \r\n" + new String(sSDPPacket.getData()));
        }
        catch (Exception exception) {
            return null;
        }
        return sSDPPacket;
    }
}

