/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.net.HostInterface;
import com.hpplay.cybergarage.soap.SOAP;
import com.hpplay.cybergarage.upnp.ssdp.SSDP;
import com.hpplay.cybergarage.xml.Parser;

public class UPnP {
    private static final String TAG = "Cyber-UPnP";
    public static final String XML_CLASS_PROPERTTY = "cyberlink.upnp.xml.parser";
    public static final String NAME = "CyberLinkJava";
    public static final String VERSION = "3.0";
    public static final int SERVER_RETRY_COUNT = 100;
    public static final int DEFAULT_EXPIRED_DEVICE_EXTRA_TIME = 60;
    public static final String INMPR03 = "INMPR03";
    public static final String INMPR03_VERSION = "1.0";
    public static final int INMPR03_DISCOVERY_OVER_WIRELESS_COUNT = 4;
    public static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    public static final int CONFIGID_UPNP_ORG_MAX = 0xFFFFFF;
    public static final int USE_ONLY_IPV6_ADDR = 1;
    public static final int USE_LOOPBACK_ADDR = 2;
    public static final int USE_IPV6_LINK_LOCAL_SCOPE = 3;
    public static final int USE_IPV6_SUBNET_SCOPE = 4;
    public static final int USE_IPV6_ADMINISTRATIVE_SCOPE = 5;
    public static final int USE_IPV6_SITE_LOCAL_SCOPE = 6;
    public static final int USE_IPV6_GLOBAL_SCOPE = 7;
    public static final int USE_SSDP_SEARCHRESPONSE_MULTIPLE_INTERFACES = 8;
    public static final int USE_ONLY_IPV4_ADDR = 9;
    private static Parser xmlParser;
    public static final int DEFAULT_TTL = 4;
    private static int timeToLive;

    public static final String getServerName() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        return string + "/" + string2 + " UPnP/1.0 " + NAME + "/" + VERSION;
    }

    public static final void setEnable(int n2) {
        switch (n2) {
            case 1: {
                HostInterface.USE_ONLY_IPV6_ADDR = true;
                break;
            }
            case 9: {
                HostInterface.USE_ONLY_IPV4_ADDR = true;
                break;
            }
            case 2: {
                HostInterface.USE_LOOPBACK_ADDR = true;
                break;
            }
            case 3: {
                SSDP.setIPv6Address("FF02::C");
                break;
            }
            case 4: {
                SSDP.setIPv6Address("FF03::C");
                break;
            }
            case 5: {
                SSDP.setIPv6Address("FF04::C");
                break;
            }
            case 6: {
                SSDP.setIPv6Address("FF05::C");
                break;
            }
            case 7: {
                SSDP.setIPv6Address("FF0E::C");
            }
        }
    }

    public static final void setDisable(int n2) {
        switch (n2) {
            case 1: {
                HostInterface.USE_ONLY_IPV6_ADDR = false;
                break;
            }
            case 9: {
                HostInterface.USE_ONLY_IPV4_ADDR = false;
                break;
            }
            case 2: {
                HostInterface.USE_LOOPBACK_ADDR = false;
            }
        }
    }

    public static final boolean isEnabled(int n2) {
        switch (n2) {
            case 1: {
                return HostInterface.USE_ONLY_IPV6_ADDR;
            }
            case 9: {
                return HostInterface.USE_ONLY_IPV4_ADDR;
            }
            case 2: {
                return HostInterface.USE_LOOPBACK_ADDR;
            }
        }
        return false;
    }

    private static final String toUUID(int n2) {
        String string = Integer.toString(n2 & 0xFFFF, 16);
        int n3 = string.length();
        String string2 = "";
        for (int i2 = 0; i2 < 4 - n3; ++i2) {
            string2 = string2 + "0";
        }
        string2 = string2 + string;
        return string2;
    }

    public static final String createUUID() {
        long l2 = System.currentTimeMillis();
        long l3 = (long)((double)System.currentTimeMillis() * Math.random());
        return UPnP.toUUID((int)(l2 & 0xFFFFL)) + "-" + UPnP.toUUID((int)(l2 >> 32 | 0xA000L) & 0xFFFF) + "-" + UPnP.toUUID((int)(l3 & 0xFFFFL)) + "-" + UPnP.toUUID((int)(l3 >> 32 | 0xE000L) & 0xFFFF);
    }

    public static final int createBootId() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static final int caluculateConfigId(String string) {
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if ((n2 += string.codePointAt(i2)) < 0xFFFFFF) continue;
            n2 %= 0xFFFFFF;
        }
        return n2;
    }

    public static final void setXMLParser(Parser parser) {
        xmlParser = parser;
        SOAP.setXMLParser(parser);
    }

    public static final Parser getXMLParser() {
        if (xmlParser == null) {
            xmlParser = UPnP.loadDefaultXMLParser();
            if (xmlParser == null) {
                throw new RuntimeException("No XML parser defined. And unable to laod any. \nTry to invoke UPnP.setXMLParser before UPnP.getXMLParser");
            }
            SOAP.setXMLParser(xmlParser);
        }
        return xmlParser;
    }

    private static Parser loadDefaultXMLParser() {
        Parser parser = null;
        String[] stringArray = new String[]{System.getProperty(XML_CLASS_PROPERTTY), "com.hpplay.cybergarage.xml.parser.XmlPullParser", "com.hpplay.cybergarage.xml.parser.JaxpParser", "com.hpplay.cybergarage.xml.parser.kXML2Parser", "com.hpplay.cybergarage.xml.parser.XercesParser"};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null) continue;
            try {
                parser = (Parser)Class.forName(stringArray[i2]).newInstance();
                return parser;
            }
            catch (Throwable throwable) {
                CLog.d(TAG, "Unable to load " + stringArray[i2] + " as XMLParser due to " + throwable);
            }
        }
        return null;
    }

    public static final void setTimeToLive(int n2) {
        timeToLive = n2;
    }

    public static final int getTimeToLive() {
        return timeToLive;
    }

    public static final void initialize() {
    }

    static {
        timeToLive = 4;
        UPnP.setTimeToLive(4);
    }
}

