/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.soap;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.http.HTTPResponse;
import com.hpplay.cybergarage.soap.SOAP;
import com.hpplay.cybergarage.soap.SOAPResponse;
import com.hpplay.cybergarage.xml.Node;
import com.hpplay.cybergarage.xml.Parser;
import java.io.ByteArrayInputStream;

public class SOAPRequest
extends HTTPRequest {
    private static final String TAG = "Cyber-SOAPRequest";
    private static final String SOAPACTION = "SOAPACTION";
    private Node rootNode;

    public SOAPRequest() {
        this.setContentType("text/xml; charset=\"utf-8\"");
        this.setMethod("POST");
    }

    public SOAPRequest(HTTPRequest hTTPRequest) {
        this.set(hTTPRequest);
    }

    public void setSOAPAction(String string) {
        this.setStringHeader(SOAPACTION, string);
    }

    public String getSOAPAction() {
        return this.getStringHeaderValue(SOAPACTION);
    }

    public boolean isSOAPAction(String string) {
        String string2 = this.getHeaderValue(SOAPACTION);
        if (string2 == null) {
            return false;
        }
        if (string2.equals(string)) {
            return true;
        }
        String string3 = this.getSOAPAction();
        if (string3 == null) {
            return false;
        }
        return string3.equals(string);
    }

    public SOAPResponse postMessage(String string, int n2) {
        HTTPResponse hTTPResponse = this.post(string, n2);
        SOAPResponse sOAPResponse = new SOAPResponse(hTTPResponse);
        byte[] byArray = sOAPResponse.getContent();
        if (byArray.length <= 0) {
            return sOAPResponse;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Parser parser = SOAP.getXMLParser();
            Node node = parser.parse(byteArrayInputStream);
            sOAPResponse.setEnvelopeNode(node);
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
        }
        return sOAPResponse;
    }

    private void setRootNode(Node node) {
        this.rootNode = node;
    }

    private synchronized Node getRootNode() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        try {
            byte[] byArray = this.getContent();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Parser parser = SOAP.getXMLParser();
            this.rootNode = parser.parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
        }
        return this.rootNode;
    }

    public void setEnvelopeNode(Node node) {
        this.setRootNode(node);
    }

    public Node getEnvelopeNode() {
        return this.getRootNode();
    }

    public Node getBodyNode() {
        Node node = this.getEnvelopeNode();
        if (node == null) {
            return null;
        }
        if (!node.hasNodes()) {
            return null;
        }
        return node.getNode(0);
    }

    public void setContent(Node node) {
        String string = "";
        string = string + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string = string + "\n";
        string = string + node.toString();
        string = string.trim();
        this.setContent(string);
    }

    @Override
    public void print() {
        CLog.d(TAG, this.toString());
        if (this.hasContent()) {
            return;
        }
        Node node = this.getRootNode();
        if (node == null) {
            return;
        }
        CLog.d(TAG, node.toString());
    }
}

