/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6;

import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import com.hpplay.component.protocol.srp6.SRP6ClientCredentials;
import com.hpplay.component.protocol.srp6.SRP6ClientEvidenceContext;
import com.hpplay.component.protocol.srp6.SRP6CryptoParams;
import com.hpplay.component.protocol.srp6.SRP6Exception;
import com.hpplay.component.protocol.srp6.SRP6ServerEvidenceContext;
import com.hpplay.component.protocol.srp6.SRP6Session;
import com.hpplay.component.protocol.srp6.URoutineContext;
import com.hpplay.component.protocol.srp6.XRoutine;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;

public class SRP6ClientSession
extends SRP6Session
implements Serializable {
    private static final long serialVersionUID = -479060216624675478L;
    private String password;
    private BigInteger x = null;
    private BigInteger a = null;
    private State state = State.INIT;
    private XRoutine xRoutine = null;

    public SRP6ClientSession(int n2) {
        super(n2);
        this.updateLastActivityTime();
    }

    public SRP6ClientSession() {
        this(0);
    }

    public void setXRoutine(XRoutine xRoutine) {
        this.xRoutine = xRoutine;
    }

    public XRoutine getXRoutine() {
        return this.xRoutine;
    }

    public void step1(String string, String string2) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("The user identity 'I' must not be null or empty");
        }
        this.userID = string;
        if (string2 == null) {
            throw new IllegalArgumentException("The user password 'P' must not be null");
        }
        this.password = string2;
        if (this.state != State.INIT) {
            throw new IllegalStateException("State violation: Session must be in INIT state");
        }
        this.state = State.STEP_1;
        this.updateLastActivityTime();
    }

    public SRP6ClientCredentials step2(SRP6CryptoParams sRP6CryptoParams, BigInteger bigInteger, BigInteger bigInteger2) {
        Object object;
        if (sRP6CryptoParams == null) {
            throw new IllegalArgumentException("The SRP-6a crypto parameters must not be null");
        }
        this.config = sRP6CryptoParams;
        MessageDigest messageDigest = sRP6CryptoParams.getMessageDigestInstance();
        if (messageDigest == null) {
            throw new IllegalArgumentException("Unsupported hash algorithm 'H': " + sRP6CryptoParams.H);
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("The salt 's' must not be null");
        }
        this.s = bigInteger;
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("The public server value 'B' must not be null");
        }
        this.B = bigInteger2;
        if (this.state != State.STEP_1) {
            throw new IllegalStateException("State violation: Session must be in STEP_1 state");
        }
        if (this.hasTimedOut()) {
            throw new SRP6Exception("Session timeout", SRP6Exception.CauseType.TIMEOUT);
        }
        if (!this.srp6Routines.isValidPublicValue(sRP6CryptoParams.N, bigInteger2)) {
            throw new SRP6Exception("Bad server public value 'B'", SRP6Exception.CauseType.BAD_PUBLIC_VALUE);
        }
        if (this.xRoutine != null) {
            this.x = this.xRoutine.computeX(sRP6CryptoParams.getMessageDigestInstance(), BigIntegerUtils.bigIntegerToBytes(bigInteger), this.userID.getBytes(Charset.forName("UTF-8")), this.password.getBytes(Charset.forName("UTF-8")));
        } else {
            this.x = this.srp6Routines.computeX(messageDigest, BigIntegerUtils.bigIntegerToBytes(bigInteger), this.password.getBytes(Charset.forName("UTF-8")));
            messageDigest.reset();
        }
        this.a = this.srp6Routines.generatePrivateValue(sRP6CryptoParams.N, this.random);
        messageDigest.reset();
        this.A = this.srp6Routines.computePublicClientValue(sRP6CryptoParams.N, sRP6CryptoParams.g, this.a);
        this.k = this.srp6Routines.computeK(messageDigest, sRP6CryptoParams.N, sRP6CryptoParams.g);
        messageDigest.reset();
        if (this.hashedKeysRoutine != null) {
            object = new URoutineContext(this.A, bigInteger2);
            this.u = this.hashedKeysRoutine.computeU(sRP6CryptoParams, (URoutineContext)object);
        } else {
            this.u = this.srp6Routines.computeU(messageDigest, sRP6CryptoParams.N, this.A, bigInteger2);
            messageDigest.reset();
        }
        this.S = this.srp6Routines.computeSessionKey(sRP6CryptoParams.N, sRP6CryptoParams.g, this.k, this.x, this.u, this.a, bigInteger2);
        if (this.clientEvidenceRoutine != null) {
            object = new SRP6ClientEvidenceContext(this.userID, bigInteger, this.A, bigInteger2, this.S);
            this.M1 = this.clientEvidenceRoutine.computeClientEvidence(sRP6CryptoParams, (SRP6ClientEvidenceContext)object);
        } else {
            this.M1 = this.srp6Routines.computeClientEvidence(messageDigest, this.A, bigInteger2, this.S);
            messageDigest.reset();
        }
        this.state = State.STEP_2;
        this.updateLastActivityTime();
        return new SRP6ClientCredentials(this.A, this.M1);
    }

    public void step3(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (bigInteger == null) {
            throw new IllegalArgumentException("The server evidence message 'M2' must not be null");
        }
        this.M2 = bigInteger;
        if (this.state != State.STEP_2) {
            throw new IllegalStateException("State violation: Session must be in STEP_2 state");
        }
        if (this.hasTimedOut()) {
            throw new SRP6Exception("Session timeout", SRP6Exception.CauseType.TIMEOUT);
        }
        if (this.serverEvidenceRoutine != null) {
            SRP6ServerEvidenceContext sRP6ServerEvidenceContext = new SRP6ServerEvidenceContext(this.A, this.M1, this.S);
            bigInteger2 = this.serverEvidenceRoutine.computeServerEvidence(this.config, sRP6ServerEvidenceContext);
        } else {
            MessageDigest messageDigest = this.config.getMessageDigestInstance();
            bigInteger2 = this.srp6Routines.computeServerEvidence(messageDigest, this.A, this.M1, this.S);
        }
        if (!bigInteger2.equals(bigInteger)) {
            throw new SRP6Exception("Bad server credentials", SRP6Exception.CauseType.BAD_CREDENTIALS);
        }
        this.state = State.STEP_3;
        this.updateLastActivityTime();
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        INIT,
        STEP_1,
        STEP_2,
        STEP_3;

    }
}

